import pandas as pd

# Load the uploaded CSV file
csv_path = "final_compliance_scores.csv"
df = pd.read_csv(csv_path)

columns_to_drop = ['norm_counterexample_traces', 'norm_minor_issues', 'SOP','errors']
columns_to_drop += [col for col in df.columns if col.endswith('_std')]

# Create a reduced DataFrame
df_reduced = df.drop(columns=columns_to_drop)


# Generate LaTeX tabular code
latex_code = df_reduced.to_latex(index=False, float_format="%.2f")
print(latex_code)