PLAN_SYSPROMPT = """You are an expert AI asistant trained in Finite State Modelling and graph formal methods.\
For the following task develop a comprehensive plan to extract kripke_structures from the given SOP text using the available tools in a creative and effective manner.\
A Kripke Structure is defined as a tuple M = (S,I,R,L) where:

- S is a set of states,
- I is the set of initial states,
- R ⊆ S x S is a transition relation (i.e., directed edges between states),
- L: S → 2^AP is a labeling function that maps each state to the set of atomic propositions true in that state.

You must produce a Kripke Structure from the given Standard Operating Procedure document.

Focus on understanding the core requirements and leveraging the strengths of each tool to explore potential solutions. \
1. Focus on understanding the core requirements.
2. Leverage the strengths of each tool to explore potential solutions
3. Make an attempt to create a exhaustive kripke strucuture encompassing all the possible states and transitions in the given system. 

You are limited to using only the following tools in your plan to help in solving the given tasks:

{tool_names}

The description for each tool is as follows:

{tools}
"""

TASK_PROMPT_1 = "Please generate a plan to investigate and collect information about Kripke Structures."

TASK_PROMPT = """
You are given a Standard Operating Procedures DOCUMENT.
The contents of the Standard Operating Procedures DOCUMENT are as follows:

{SOP_TXT}
"""

PLAN_PROMPT_1 = """
Please generate a plan to investigate and collect information about Kripke Structures.
Write a two step PLAN to describe how to solve the following query:

- What are Kripke Structures?

When writing the plan:

- Write the PLAN starting with the header 'PLAN:' followed by a numbered list of steps (e.g., 1. 2.). Do not add any unnecessary steps.
- The final step should always be: "Based on the above steps taken, please provide a conclusive answer for the given query."
- End the updated plan with the marker: `<END_OF_PLAN>` (on a new line, without a number).
"""

PLAN_PROMPT = """{SOP_TASK}

Please generate a plan to create a detailed Kripke Structure of this system in NuSMV code syntax.

Your PLAN must describe how to solve the following TASKS:

1. Retrieve specific information and locate relevant sections within the document using `crag_tool` call. Make sure the query is a single combined string retrieving all the relevant sections of SOP. 
2. Using the results from Step 1 generate a List of possible states in which
    - Extract all the possible states (operational modes) the following system can be in.
    - Extract all the Dynamic variables or quantities that may vary during the execution.
    - Atomic propositions of the system.
3. Verify that the output from previous is coherent(typed, complete and consistent) then append all the operational modes, dynamic variables and atomic propositions into a single string `candidate_states` and pass it to `create_states` tool.
4. Write the NuSMV code from previous step's output to a file named `states.smv`.
5. Using the results from Step 1 generate a List of possible transitions in which
    - Use the extracted states from the previous step to look for keywords in the documents that might trigger any of those states.
    - Other transitions that could potentially happen between the extracted states.
6. Verify that the output from the previous step is coherent (typed, complete  and consistent).
7. Gather the extracted states, dynamic variables from previous steps and append them into a single string `states` and verified transition-triggers from the penultimate step as a single string `candidate_triggers` and pass it to `create_transitions` tool.
8. Save the NuSMV code from previous step's output to a file named `trans.smv`.
7. Finally populate the `ASSIGN` section of the code block from last step with initial values for dynamic variables and initial_state.
8. Save the complete finalized NuSMV code to a file named `kripke.smv`."

Ensure the plan is complete, logically ordered and specific about how states and transitions can be extracted to describe the system from the given document.
The purpose of this plan is to guide the creation of a Kripke Structure that accurately describes the underlying system and it's behaviours.

When writing the plan:

- Write the PLAN starting with the header 'PLAN:' followed by a numbered list of steps (e.g., 1. 2. 3.). Do not add any unnecessary steps.
- The final step should always be: "Based on the above steps taken, please provide a conclusive answer for the given TASKS."
- End the updated plan with the marker: `<END_OF_PLAN>` (on a new line, without a number).
"""


CORRECTION_PROMPT  = """"Given the following SOP TEXT:
{DOC_TXT}

You are provided with a detailed, step-by-step implementation plan for creating this Kripke structure from the SOP document.

CURRENT PLAN:
-------------

{plan}

The CURRENT PLAN has been carried out up to **STEP {current_step}**, and the output for executed step is shown below:

{intermediate_steps}

Your task is to update the plan starting from **STEP {future_step}** onward to ensure all tasks described by each of the previously executed steps are complete.

When updating the plan:

- Write the PLAN starting with the header 'PLAN:'.
- Do **not** modify any of the executed steps in the original plan.
- Do **not** reduce the number of steps in the updated plan; you may only add or revise **future** steps as needed to complete previous tasks.
- Ensure each step in the updated plan is clearly numbered (e.g., 1., 2., 3.).
- The final step should always be: "Based on the above steps taken, please provide a conclusive answer for the given TASKS."
- End the updated plan with the marker: `<END_OF_PLAN>` (on a new line, without a number).
"""


PROP_PLAN_SYSPROMPT_1 = """You are an expert AI assistant trained in Formal Verification and Model Checking methods.
Your tasks is to collect and summarize knowledge about properties in context of model checking. 
Your objective is to provide information to another agent and set it up for creating those properties.
"""

PROP_PLAN_SYSPROMPT = """You are an expert AI assistant trained in Formal Verification and Model Checking methods.
Properties are formal specifications that describe the desired behavior or characteristics of a system.
These properties are typically expressed in temporal logic (e.g. Computation Tree Logic) and are used to verify whether a system model satisfies certain requirements. \

For example, properties can specify that:

-A certain condition will always hold (safety-invariant property).
-A certain condition will hold for the specific transitions in the system. (safety-transition property)
-A specific event will eventually occur (liveness property).
-A system does not unfairly favor one process or condition over another.(Fairness property)
-A certain states or conditions can be reached in the system. (Reachability)
The sequence in which events or states occur over time (Temporal-ordering property)
Certain states are mutually exclusive. 

You must produce a collection of properties for the given Kripke Structure. The properties serve the purpose of checking the system.

1. Focus on understanding the core requirements.
2. Make an attempt to create a exhaustive collection of properties of all types encompassing all the possible invariants and properties to check the given system. 

You are limited to using only the following tools in your plan to help in solving the given tasks:

{tool_names}

The description for each tool is as follows:

{tools}
"""

PROP_TASK_PROMPT_1 = "Please generate a plan to investigate and collect information about properties in context of model checking."

PROP_TASK_PROMPT = """You are given a Standard Operating Procedures DOCUMENT.
The contents of the Standard Operating Procedures DOCUMENT are as follows:

{SOP_TXT}
"""

PROP_PLAN_PROMPT_1 = """
Please generate a plan to investigate and collect information about Properties in context of Model checking.
Write a two step PLAN to describe how to solve the following query:

- What are properties in context of Model Checking?

When writing the plan:

- Write the PLAN starting with the header 'PLAN:' followed by a numbered list of steps (e.g., 1. 2.). Do not add any unnecessary steps.
- The final step should always be: "Based on the above steps taken, please provide a detailed answer for the given query."
- End the updated plan with the marker: `<END_OF_PLAN>` (on a new line, without a number).
"""

PROP_PLAN_PROMPT = """{PROP_TASK}

Please generate a plan to create a detailed list of Properties of this system.

Your PLAN must describe how to solve the following TASKS:
1. Identify a concise, one-line label for the target system using the SOP document and its context (e.g., "Arm robot controller").
2. Generate natural language text properties from from the output of `Step 1`.The `generate_nl_descriptions` tool can be used to perform this task.
3. Organize the outputs from `Step 2` into distinct categories. The `categorize_properties` tool can be used to perform this task.
4. Ensure to generate finalized CTL/LTL/SPEC properties for given system from the outputs of `Step 3`. Use the `generate_spec_properties` tool even if all properties have been generated in a previous step.
5. Save the output from `Step 4` to a file called `properties.smv`. The `save_nusmv` tool can be used to perform this task.

Ensure the plan is complete, logically ordered and specific about properties can be extracted to verify and check the system's behavior from the given SOP given document.
The purpose of this plan is to guide the creation of a Property Specifications that accurately describes the underlying system and validates it's behaviors.

When writing the plan:

- Write the PLAN starting with the header 'PLAN:' followed by a numbered list of steps (e.g., 1. 2. 3.). Do not add any unnecessary steps.
- The final step should always be: "Based on the above steps taken, please provide a conclusive answer for the given TASKS."
- End the updated plan with the marker: `<END_OF_PLAN>` (on a new line, without a number).
"""


PROP_CORRECTION_PROMPT = """Given the following Kripke Structure:
{kripke}

And SOP document:
{DOC_TXT}

You are provided with a detailed, step-by-step implementation plan for generating properties for this Kripke structure from the SOP document.

CURRENT PLAN:
-------------

{plan}

The CURRENT PLAN has been carried out up to **STEP {current_step}**, and the output for executed step is shown below:

{intermediate_steps}

Your task is to update the plan starting from **STEP {future_step}** onward to ensure all tasks described by each of the previously executed steps are complete.

When updating the plan:

- Write the PLAN starting with the header 'PLAN:'.
- Do **not** modify any of the executed steps in the original plan.
- Do **not** reduce the number of steps in the updated plan; you may only add or revise **future** steps as needed to complete previous tasks.
- Ensure each step in the updated plan is clearly numbered (e.g., 1., 2., 3.).
- The final step should always be: "Based on the above steps taken, please provide a conclusive answer for the given TASKS."
- End the updated plan with the marker: `<END_OF_PLAN>` (on a new line, without a number).
"""


NUSMV_PLAN_SYS = """You are an expert AI assistant trained in formal verification and NuSMV syntax.
Your tasks is to collect and summarize knowledge about NuSMV model checker and writing NuSMV code files. 
Your objective is to provide information for creating a complete, runnable NuSMV model.

You are limited to using only the following tools in your plan to help in solving the given tasks:

{tool_names}

The description for each tool is as follows:

{tools}
"""

NUSMV_PLAN_SYS_1 = """You are an expert AI assistant trained in formal verification and NuSMV syntax. \
Your task is to generate a PLAN for assembling a **complete, runnable NuSMV model** from the following partial artifacts that may be provided at runtime: \
(1) a list of STATES, (2) TRANSITION relationships, and (3) a set of CTL/LTL/SEPC PROPERTIES. \
A valid NuSMV model must contain, at minimum, the sections MODULE main, VAR, ASSIGN (or TRANS), and one or more CTL/LTL/SPEC statements.

You are limited to using only the following tools in your plan to help in solving the given tasks:

{tool_names}

The description for each tool is as follows:

{tools}
"""

NUSMV_TASK_PROMPT_1 = """Please generate a plan to investigate and collect information about NuSMV model checker and how to create a working NuSMV code to verify a system.
"""

NUSMV_TASK_PROMPT =  """You are given the following context about NuSMV model checker for a system in order to write new NuSMV code files:

{context}
"""

NUSMV_PLAN_PROMPT = """Please generate a plan to investigate and collect information about Kripke Structures.
Write a two step PLAN to describe how to solve the following TASK:

- A detailed description on how to represent a Kripke Structure and the associated Properties for a system in NuSMV model checker?

When writing the plan:

- Write the PLAN starting with the header 'PLAN:' followed by a numbered list of steps (e.g., 1. 2.). Do not add any unnecessary steps.
- The final step should always be: "Based on the above steps taken, please provide a conclusive answer for the TASK"
- End the updated plan with the marker: `<END_OF_PLAN>` (on a new line, without a number).
"""

NUSMV_PLAN_PROMPT_1 = """{NUSMV_TASK}

Your task is to devise a detailed, step-by-step PLAN that **merges** the given NuSMV code segments into a single, coherent, and runnable NuSMV file.  
The final model must load in NuSMV without syntax errors **and** remain semantically consistent (all variables referenced exactly match their declarations, no duplicate or missing sections).

Your PLAN must describe how to solve the following TASKS:
1. Use the `crag_tool` to gather any required information about the NuSMV model checker and the specifics of writing a NuSMV model file.
2. Assemble the full NuSMV model file using the contents of `states.smv`, `kripke.smv` and `properties.smv`. The `nusmv_codepad` tool can be used for this task.
3. Save the output from `Step 2` to a file called `{model_name}`. The `save_nusmv` tool can be used to perform this task.

Ensure the plan is complete, logically ordered and specific about how states, transitions and properties can be extracted from the given documents to describe the system.
The purpose of this plan is to guide the creation of a NuSMV model file that accurately describes the underlying system and it's behaviours.

When writing the plan:

- Write the PLAN starting with the header 'PLAN:' followed by a numbered list of steps (e.g., 1. 2. 3.). Do not add any unnecessary steps.
- The final step should always be: "Based on the above steps taken, please provide a conclusive answer for the given TASKS."
- End the updated plan with the marker: `<END_OF_PLAN>` (on a new line, without a number).
"""


NUSMV_EXECUTION_TASK = """Please perform the following tasks in order:

1. List all content in the current working directory.
2. Read the contents of the file named "kripke.smv".
3. Provide a conclusive answer for tasks '1' and '2'.
"""

PROP_EXECUTION_TASK = """Please perform the following tasks in order:

1. List all content in the current working directory.
2. Read the contents of the file named "properties.smv".
3. Provide a conclusive answer for tasks '1' and '2'.
"""

NUSMV_PLANNER_EXECUTION_TASK = """Please perform the following tasks in order:

1. List all contents of the current working directory.
2. Read the NuSMV model file named `{model_name}`.
3. Execute the file using the `execute_nusmv` tool.
4. If execution fails or if there are counterexample traces present for any specification:
   - Always use the `crag_tool` tool to first gather information about current Standard Operating Procedurs (SOP) and potential fixes to address the errors/counterexample.
   - Use the `debug_nusmv` tool to revise the code and fix all errors or counterexample traces.
   - Overwrite the existing NuSMV model file with the updated code using 'save_nusmv' tool.
   - Re-execute the file using the `execute_nusmv` tool.
   - Repeat Step 4 until the program executes successfully without errors.
5. Once execution is successful, provide a conclusive answer based on the output.
"""