## PICO - Pragmatic Image Compression

[PICO]() is a lossy image compression algorithm that adapts compression to user behavior, optimizing reconstructions to be useful for downstream tasks instead of preserving visual appearance.

## Usage

1.  Clone `pico` into your home directory `~`
2.  Download [data.zip]() and decompress it into `pico/`
3.  Setup an Anaconda virtual environment with `conda create -n picoenv python=3.6`
4.  Install dependencies with `pip install -r requirements-{a,b}.txt` (`a` for mnist and carracing, `b` for celeba and lcars)
5.  Install the `pico` package with `python setup.py install`
6.  Jupyter notebooks in `pico/notebooks` provide an entry-point to the code base, where you can
    play around with the environments and reproduce the figures from the paper.

## Citation

If you find this software useful in your work, we kindly request that you cite the following
[paper](https://arxiv.org/abs/):

```
@article{,
  title={Pragmatic Image Compression for Human-in-the-Loop Decision-Making},
  author={},
  journal={arXiv preprint arXiv:},
  year={2021}
}
```
