# Newton–Cotes Graph Neural Networks: On the Time Evolution of Dynamic Systems


## Quick Start


**1. Installation**


```bash
conda env create -f requirement.yaml
```

**2. Run NC (GMN) on MD17-Aspirin**

```bash
python -u spatial_graph/main_ncgnn.py --config_by_file \
                --model gmn	 \
                --use_extra_data 0 \
                --n_step 2 \
                --dataset md17 \
                --l2_penalty 1 \
```


**2. Run NC+ (GMN)**

```bash
python -u spatial_graph/main_ncgnn.py --config_by_file \
                --model gmn	 \
                --use_extra_data 1 \
                --n_step 2 \
                --dataset md17 \
                --l2_penalty 1 \
```


## Run on Other Datasets

**1. N-body**

Generate the dataset identical to that used by GMN:

```bash
python -u generate_dataset.py --num-train 5000 --seed 43 --n_isolated 3 --n_stick 2 --n_hinge 1 --n_workers 50
```

Run on the generated dataset:

```bash
python -u spatial_graph/main_ncgnn.py --config_by_file \
                --model gmn	 \
                --use_extra_data 1 \
                --n_step 2 \
                --dataset nbody \
                --n_isolated 3 --n_stick 2 --n_hinge 1 \
                --l2_penalty 1 \
```
Note that n_isolated, n_stick, and n_hinge should match the generation settings exactly.

**2. MD17**

The MD17 dataset can be downloaded from [MD17](http://quantum-machine.org/gdml/#datasets). Download the dataset and place the files under `spatial_graph/MD17`.

**3. Motion Capture**

The raw data were obtained via [CMU Motion Capture Database](http://mocap.cs.cmu.edu/search.php?subjectnumber=35). 

Run on the motion dataset:

```bash
python -u spatial_graph/main_ncgnn.py --config_by_file \
                --model gmn	 \
                --use_extra_data 1 \
                --n_step 2 \
                --dataset motion \
                --l2_penalty 1 \
```

## Special Thanks

This source code is adaped from the official repository of [GMN](https://github.com/hanjq17/GMN).