#!/bin/bash

# Define an array of percent values
percents=(100)
horizons=(336)
widths=(2 4 6)

# Loop through each percent value in the array
for percent in "${percents[@]}"
do
    for horizon in "${horizons[@]}"
    do
    for width in "${widths[@]}"
    do
        # Note: Each python command will complete before the next one starts.
        python3 -u run.py \
        --is_training 1 \
        --root_path ./dataset/weather/ \
        --data_path weather.csv \
        --model_id "051484.1_weather_${horizon}_192_dim${width}_percentIs${percent}" \
        --model iTransformer \
        --data custom \
        --features M \
        --percent $percent \
        --seq_len $horizon \
        --label_len 1 \
        --pred_len 192 \
        --e_layers 2 \
        --enc_in 21 \
        --dec_in 21 \
        --c_out 21 \
        --des 'Exp' \
        --d_model $width \
        --d_ff $width \
        --batch_size 32 \
        --train_epochs 60 \
        --learning_rate 0.0004 \
        --weight_decay 0.00001 \
        --patience 10 \
        --coef 0.95 \
        --n_head 2 \
        --itr 3 >> "051484.1_weather_${horizon}_192_dim${width}_percent${percent}.log"
        wait
    done
    done
done
