#!/bin/bash

# Define the array of percent values
percents=(2 3 4 8 11 16 25 32 50 60 80 100)

# Define the array of interpolate_len values
horizon_lens=(6 12 16 24)

# Loop over each percent value
for percent in "${percents[@]}"; do
    # Loop over each interpolate_len value
    for horizon in "${horizon_lens[@]}"; do
        # Define model_id and log file name dynamically based on current percent and interpolate_len
        model_id="New042951.3__7683l_MLPinterpolate_electricity_interto${horizon}__${horizon}_192__p${percent}_lr1e-3_wd1e-5_lasso0_bs22648"
        log_file="${model_id}.log"

        # Run the Python script with current configurations
        nohup python3 -u run.py \
            --exp_name MTSF \
            --is_training 1 \
            --root_path ./dataset/electricity/ \
            --data_path electricity.csv \
            --model_id "$model_id" \
            --model MLP_interpolate \
            --in_patch_stride 1 --in_patch_size 1 \
            --out_patch_stride 1 --out_patch_size 1 \
            --data custom \
            --features M \
            --interpolate_len "$horizon" \
            --seq_len "$horizon" \
            --pred_len 192 \
            --label_len 5 \
            --des 'Exp' \
            --e_layers 3 \
            --d_model 768 \
            --enc_in 21 \
            --dec_in 21 \
            --c_out 21 \
            --d_ff 192 \
            --itr 1 \
            --batch_size 8192 \
            --train_epochs 100 \
            --learning_rate 0.001 \
            --weight_decay 0.00001 \
            --l1_lambda 0.0 \
            --percent "$percent" \
            --patience 10 \
            --coef 0.98 >> "$log_file"
        wait
    done
done


