#!/bin/bash

# Define an array of percent values
percents=(10 15 20 25 30 35 40 50 80 100)

# Loop through each percent value in the array
for percent in "${percents[@]}"
do
    # Note: Each python command will complete before the next one starts.
    python3 -u run.py \
    --is_training 1 \
    --root_path ./dataset/traffic/ \
    --data_path traffic.csv \
    --model_id "043063_traffic_336_192_percentIs${percent}_another2Iter" \
    --model iTransformer \
    --data custom \
    --features M \
    --percent $percent \
    --seq_len 336 \
    --label_len 192 \
    --pred_len 192 \
    --e_layers 4 \
    --enc_in 862 \
    --dec_in 862 \
    --c_out 862 \
    --des 'Exp' \
    --d_model 512 \
    --d_ff 512 \
    --batch_size 20 \
    --train_epochs 60 \
    --learning_rate 0.0004 \
    --weight_decay 0.00001 \
    --patience 10 \
    --coef 0.95 \
    --itr 2 >> "043063_traffic_336_192_percent${percent}_another2Iter.log"
    wait
done
