#!/bin/bash

# Define an array of percent values
widths=(4 6 8 12 16 32 64 128 256)
horizons=(128 256 336 396 512 768 1024 1536)

# Loop through each percent value in the array
for width in "${widths[@]}"
do
    # Note: Each python command will complete before the next one starts.
    python3 -u run.py \
    --is_training 1 \
    --root_path ./dataset/ETT-small/ \
    --data_path ETTh1.csv \
    --model_id "050561_ETTh1_336_192_p100_widthIs${width}" \
    --model iTransformer \
    --data ETTh1 \
    --features M \
    --percent 100 \
    --seq_len 336 \
    --label_len 192 \
    --pred_len 192 \
    --e_layers 2 \
    --enc_in 7 \
    --dec_in 7 \
    --c_out 7 \
    --des 'Exp' \
    --d_model $width \
    --d_ff $width \
    --batch_size 20 \
    --train_epochs 60 \
    --learning_rate 0.003 \
    --weight_decay 0.0005 \
    --patience 10 \
    --coef 0.95 \
    --itr 3 >> "050561_ETTh1_336_192_percentIs100_widthIs${width}.log"
    wait
done
wait

# for width in "${widths[@]}"
# do
#     # Note: Each python command will complete before the next one starts.
#     python3 -u run.py \
#     --is_training 1 \
#     --root_path ./dataset/ETT-small/ \
#     --data_path ETTh2.csv \
#     --model_id "050376_ETTh2_336_192_p100_widthIs${width}" \
#     --model iTransformer \
#     --data ETTh1 \
#     --features M \
#     --percent 100 \
#     --seq_len 336 \
#     --label_len 192 \
#     --pred_len 192 \
#     --e_layers 2 \
#     --enc_in 7 \
#     --dec_in 7 \
#     --c_out 7 \
#     --des 'Exp' \
#     --d_model $width \
#     --d_ff $width \
#     --batch_size 20 \
#     --train_epochs 60 \
#     --learning_rate 0.003 \
#     --weight_decay 0.0005 \
#     --patience 10 \
#     --coef 0.95 \
#     --itr 3 >> "050376_ETTh2_336_192_p100_widthIs${width}.log"
#     wait
# done
# wait

# for width in "${widths[@]}"
# do
#     # Note: Each python command will complete before the next one starts.
#     python3 -u run.py \
#     --is_training 1 \
#     --root_path ./dataset/ETT-small/ \
#     --data_path ETTm1.csv \
#     --model_id "050376_ETTm1_336_192_p100_widthIs${width}" \
#     --model iTransformer \
#     --data ETTm1 \
#     --features M \
#     --percent 100 \
#     --seq_len 336 \
#     --label_len 192 \
#     --pred_len 192 \
#     --e_layers 2 \
#     --enc_in 7 \
#     --dec_in 7 \
#     --c_out 7 \
#     --des 'Exp' \
#     --d_model $width \
#     --d_ff $width \
#     --batch_size 20 \
#     --train_epochs 60 \
#     --learning_rate 0.003 \
#     --weight_decay 0.0005 \
#     --patience 10 \
#     --coef 0.95 \
#     --itr 3 >> "050376_ETTm1_336_192_p100_widthIs${width}.log"
#     wait
# done
# wait

# for width in "${widths[@]}"
# do
#     # Note: Each python command will complete before the next one starts.
#     python3 -u run.py \
#     --is_training 1 \
#     --root_path ./dataset/ETT-small/ \
#     --data_path ETTm2.csv \
#     --model_id "050376_ETTm2_336_192_p100_widthIs${width}" \
#     --model iTransformer \
#     --data ETTm1 \
#     --features M \
#     --percent 100 \
#     --seq_len 336 \
#     --label_len 192 \
#     --pred_len 192 \
#     --e_layers 2 \
#     --enc_in 7 \
#     --dec_in 7 \
#     --c_out 7 \
#     --des 'Exp' \
#     --d_model $width \
#     --d_ff $width \
#     --batch_size 20 \
#     --train_epochs 60 \
#     --learning_rate 0.003 \
#     --weight_decay 0.0005 \
#     --patience 10 \
#     --coef 0.95 \
#     --itr 3 >> "050376_ETTm2_336_192_p100_widthIs${width}.log"
#     wait
# done
# wait