percents=(11 20 30 40 50 60 80 100)

horizon_lens=(6)

# Loop over each percent value
for percent in "${percents[@]}"; do
    # Loop over each interpolate_len value
    for horizon in "${horizon_lens[@]}"; do
        # Define model_id and log file name dynamically based on current percent and interpolate_len
        model_id="New051451.2_exchange_dim64_ModernTCN_interto${horizon}__${horizon}_192__p${percent}_lr5e-5_wd0.0_bs16"
        log_file="${model_id}.log"
        # Run the Python script with current configurations
        nohup python3 -u run.py \
            --is_training 1 \
            --root_path ./all_six_datasets/exchange_rate/ \
            --data_path exchange_rate.csv \
            --model_id "$model_id" \
            --model ModernTCN \
            --data custom --features M \
            --seq_len "$horizon" --pred_len 192 \
            --label_len 0 \
            --ffn_ratio 1 --patch_size 1 \
            --patch_stride 1 --num_blocks 1 \
            --large_size 51 --small_size 5 \
            --dims 64 64 64 64 --head_dropout 0.6 \
            --enc_in 8 --dropout 0.2 --itr 3 \
            --train_epochs 100 --batch_size 64 \
            --patience 10 --learning_rate 0.0001 \
            --des Exp --use_multi_scale False \
            --small_kernel_merged False --coef 0.95 \
            --percent "$percent" \
            --patience 10 \
            --coef 0.95 >> "$log_file" &
        wait
        rm -rf /root/moderntcn/ModernTCN-Long-term-forecasting/checkpoints/*
    done
done
percents=(11 20 30 40 50 60 80 100)

horizon_lens=(64 64 128 256 336 512 768 1024)