percents=(100)

widths=(4 6 8 12 16 24 32 36)

horizon_lens=(64 128 256 336 396 512 768 1024 1280 1536)

# Loop over each percent value
for percent in "${percents[@]}"; do
    # Loop over each interpolate_len value
    for horizon in "${horizon_lens[@]}"; do
    for width in "${widths[@]}"; do
        # dw_width = 4 * width.
        dw_width=$((4 * width))
        wait
        # Define model_id and log file name dynamically based on current percent and interpolate_len
        model_id="New050861_traffic_dim${width}_ModernTCN_interto${horizon}__${horizon}_192__p${percent}_lr5e-5_wd0.0_bs16"
        log_file="${model_id}.log"
        # Run the Python script with current configurations
        nohup python3 -u run.py \
            --is_training 1 \
            --root_path ./all_six_datasets/traffic/ \
            --data_path traffic.csv \
            --model_id "$model_id" \
            --model ModernTCN \
            --data custom --features M \
            --seq_len "$horizon" --pred_len 192 \
            --ffn_ratio 4 --patch_size 8 \
            --patch_stride 4 --num_blocks 1 \
            --large_size 51 --small_size 5 \
            --dims "$width" "$width" "$width" "$width" --dw_dims "$dw_width" "$dw_width" "$dw_width" "$dw_width" --head_dropout 0.0 \
            --enc_in 862 --dropout 0.8 --itr 1 \
            --train_epochs 40 --batch_size 16 \
            --patience 10 --learning_rate 0.00005 \
            --des Exp --use_multi_scale False \
            --small_kernel_merged False --coef 0.95 \
            --percent "$percent" \
            --patience 10 \
            --coef 0.95 >> "$log_file" &
        wait
        rm -rf /root/moderntcn/ModernTCN-Long-term-forecasting/checkpoints/*
    done
    done
done