/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.algorithm;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.structure.Path;
import de.unima.ki.anyburl.structure.Rule;
import java.util.ArrayList;
import java.util.Random;

public class PathSampler {
    private TripleSet ts;
    private Random rand = new Random();

    public static void main(String[] args) {
    }

    public PathSampler(TripleSet ts) {
        this.ts = ts;
    }

    public Path samplePath(int steps, boolean cyclic) {
        return this.samplePath(steps, cyclic, null);
    }

    public Path samplePath(int steps, boolean cyclic, Triple chosenHeadTriple) {
        return this.samplePath(steps, cyclic, chosenHeadTriple, null);
    }

    public Path samplePath(int steps, boolean cyclic, Triple chosenHeadTriple, Rule ruleToBeExtended) {
        ArrayList<Triple> chosenTriples;
        String[] nodes = new String[1 + steps * 2];
        char[] markers = new char[steps];
        if (Settings.SINGLE_RELATIONS != null) {
            int rdice = this.rand.nextInt(Settings.SINGLE_RELATIONS.length);
            String singleRelation = Settings.SINGLE_RELATIONS[rdice];
            chosenTriples = this.ts.getTriplesByRelation(singleRelation);
            if (chosenTriples.size() == 0) {
                System.err.println("chosen a SINGLE_RELATION=" + singleRelation + " that is not instantiated in the training data");
                System.exit(0);
            }
        } else {
            chosenTriples = this.ts.getTriples();
        }
        Triple triple = null;
        if (chosenHeadTriple == null) {
            int dice = this.rand.nextInt(chosenTriples.size());
            triple = chosenTriples.get(dice);
        } else {
            triple = chosenHeadTriple;
        }
        if (triple.getHead().equals(triple.getTail())) {
            return null;
        }
        double dice = this.rand.nextDouble();
        if (ruleToBeExtended != null) {
            if (ruleToBeExtended.isXRule()) {
                dice = 1.0;
            }
            if (ruleToBeExtended.isYRule()) {
                dice = 0.0;
            }
        }
        if (dice < 0.5) {
            markers[0] = 43;
            nodes[0] = triple.getHead();
            nodes[1] = triple.getRelation();
            nodes[2] = triple.getTail();
        } else {
            markers[0] = 45;
            nodes[2] = triple.getHead();
            nodes[1] = triple.getRelation();
            nodes[0] = triple.getTail();
        }
        int index = 1;
        while (index < steps) {
            Triple nextTriple;
            ArrayList<Triple> cyclicCandidateTriples;
            ArrayList<Triple> candidateTriples;
            if (this.rand.nextDouble() < 0.5) {
                candidateTriples = this.ts.getTriplesByHead(nodes[index * 2]);
                if (candidateTriples.size() == 0) {
                    return null;
                }
                if (cyclic && index + 1 == steps) {
                    cyclicCandidateTriples = new ArrayList<Triple>();
                    for (Triple t : candidateTriples) {
                        if (!t.getTail().equals(nodes[0])) continue;
                        cyclicCandidateTriples.add(t);
                    }
                    if (cyclicCandidateTriples.size() == 0) {
                        return null;
                    }
                    nextTriple = (Triple)cyclicCandidateTriples.get(this.rand.nextInt(cyclicCandidateTriples.size()));
                } else {
                    nextTriple = candidateTriples.get(this.rand.nextInt(candidateTriples.size()));
                }
                nodes[index * 2 + 1] = nextTriple.getRelation();
                nodes[index * 2 + 2] = nextTriple.getTail();
                markers[index] = 43;
            } else {
                candidateTriples = this.ts.getTriplesByTail(nodes[index * 2]);
                if (candidateTriples.size() == 0) {
                    return null;
                }
                if (cyclic && index + 1 == steps) {
                    cyclicCandidateTriples = new ArrayList();
                    for (Triple t : candidateTriples) {
                        if (!t.getHead().equals(nodes[0])) continue;
                        cyclicCandidateTriples.add(t);
                    }
                    if (cyclicCandidateTriples.size() == 0) {
                        return null;
                    }
                    nextTriple = (Triple)cyclicCandidateTriples.get(this.rand.nextInt(cyclicCandidateTriples.size()));
                } else {
                    nextTriple = candidateTriples.get(this.rand.nextInt(candidateTriples.size()));
                }
                nodes[index * 2 + 1] = nextTriple.getRelation();
                nodes[index * 2 + 2] = nextTriple.getHead();
                markers[index] = 45;
            }
            ++index;
        }
        Path p = new Path(nodes, markers);
        if (!cyclic && p.isCyclic()) {
            return null;
        }
        return p;
    }
}

