/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.data;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.AnnotatedTriple;
import de.unima.ki.anyburl.data.Triple;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public class TripleSet {
    private ArrayList<Triple> triples;
    private HashMap<AnnotatedTriple, Double> atriples = new HashMap();
    private Random rand;
    HashMap<String, ArrayList<Triple>> headToList;
    HashMap<String, ArrayList<Triple>> tailToList;
    HashMap<String, ArrayList<Triple>> relationToList;
    HashMap<String, HashMap<String, HashSet<String>>> headRelation2Tail;
    HashMap<String, HashMap<String, HashSet<String>>> headTail2Relation;
    HashMap<String, HashMap<String, HashSet<String>>> tailRelation2Head;
    HashMap<String, HashMap<String, ArrayList<String>>> headRelation2TailList;
    HashMap<String, HashMap<String, ArrayList<String>>> tailRelation2HeadList;
    HashSet<String> frequentRelations = new HashSet();
    HashMap<String, ArrayList<String>> relation2HeadSample = new HashMap();
    HashMap<String, ArrayList<String>> relation2TailSample = new HashMap();

    public static void main(String[] args) {
    }

    public TripleSet(String filepath) {
        this();
        this.readTriples(filepath);
        this.indexTriples();
        this.setupListStructure();
    }

    public TripleSet() {
        this.rand = new Random();
        this.triples = new ArrayList();
        this.headToList = new HashMap();
        this.tailToList = new HashMap();
        this.relationToList = new HashMap();
        this.headRelation2Tail = new HashMap();
        this.headTail2Relation = new HashMap();
        this.tailRelation2Head = new HashMap();
        this.headRelation2TailList = new HashMap();
        this.tailRelation2HeadList = new HashMap();
    }

    public void addTripleSet(TripleSet ts) {
        for (Triple t : ts.triples) {
            this.addTriple(t);
        }
        for (AnnotatedTriple at : ts.atriples.keySet()) {
            this.addTriple(at);
        }
    }

    public void addTriple(AnnotatedTriple t) {
        if (this.isTrue(t) && !this.atriples.containsKey(t)) {
            return;
        }
        if (this.atriples.containsKey(t)) {
            double storedConfidence = this.atriples.get(t);
            double newConfidence = t.getConfidence();
            if (newConfidence > storedConfidence) {
                this.atriples.put(t, t.getConfidence());
            }
        } else {
            this.atriples.put(t, t.getConfidence());
            this.addTripleToIndex(t);
        }
    }

    public void addTriple(Triple t) {
        if (this.isTrue(t) && !this.atriples.containsKey(t)) {
            return;
        }
        this.triples.add(t);
        if (this.atriples.containsKey(t)) {
            this.atriples.remove(t);
        } else {
            this.addTripleToIndex(t);
        }
    }

    private void indexTriples() {
        long tCounter = 0L;
        long divisor = 10000L;
        for (Triple t : this.triples) {
            if (++tCounter % divisor == 0L) {
                System.out.println("* indexed " + tCounter + " triples");
                divisor *= 2L;
            }
            this.addTripleToIndex(t);
        }
        System.out.println("* set up index for " + this.relationToList.keySet().size() + " relations, " + this.headToList.keySet().size() + " head entities, and " + this.tailToList.keySet().size() + " tail entities");
    }

    private void setupListStructure() {
        System.out.print("* set up list structure ... ");
        for (String head : this.headRelation2Tail.keySet()) {
            this.headRelation2TailList.put(head, new HashMap());
            for (String relation : this.headRelation2Tail.get(head).keySet()) {
                this.headRelation2TailList.get(head).put(relation, new ArrayList());
                this.headRelation2TailList.get(head).get(relation).addAll((Collection<String>)this.headRelation2Tail.get(head).get(relation));
            }
        }
        for (String tail : this.tailRelation2Head.keySet()) {
            this.tailRelation2HeadList.put(tail, new HashMap());
            for (String relation : this.tailRelation2Head.get(tail).keySet()) {
                this.tailRelation2HeadList.get(tail).put(relation, new ArrayList());
                this.tailRelation2HeadList.get(tail).get(relation).addAll((Collection<String>)this.tailRelation2Head.get(tail).get(relation));
            }
        }
        System.out.println(" done");
    }

    private void addTripleToIndex(Triple t) {
        String head = t.getHead();
        String tail = t.getTail();
        String relation = t.getRelation();
        if (!this.headToList.containsKey(head)) {
            this.headToList.put(head, new ArrayList());
        }
        this.headToList.get(head).add(t);
        if (!this.tailToList.containsKey(tail)) {
            this.tailToList.put(tail, new ArrayList());
        }
        this.tailToList.get(tail).add(t);
        if (!this.relationToList.containsKey(relation)) {
            this.relationToList.put(relation, new ArrayList());
        }
        this.relationToList.get(relation).add(t);
        if (!this.headRelation2Tail.containsKey(head)) {
            this.headRelation2Tail.put(head, new HashMap());
        }
        if (!this.headRelation2Tail.get(head).containsKey(relation)) {
            this.headRelation2Tail.get(head).put(relation, new HashSet());
        }
        this.headRelation2Tail.get(head).get(relation).add(tail);
        if (!this.tailRelation2Head.containsKey(tail)) {
            this.tailRelation2Head.put(tail, new HashMap());
        }
        if (!this.tailRelation2Head.get(tail).containsKey(relation)) {
            this.tailRelation2Head.get(tail).put(relation, new HashSet());
        }
        this.tailRelation2Head.get(tail).get(relation).add(head);
        if (!this.headTail2Relation.containsKey(head)) {
            this.headTail2Relation.put(head, new HashMap());
        }
        if (!this.headTail2Relation.get(head).containsKey(tail)) {
            this.headTail2Relation.get(head).put(tail, new HashSet());
        }
        this.headTail2Relation.get(head).get(tail).add(relation);
    }

    private void readTriples(String filepath) {
        Path file = new File(filepath).toPath();
        Charset charset = Charset.forName("UTF8");
        String line = null;
        long lineCounter = 0L;
        try {
            Throwable throwable = null;
            Object var8_9 = null;
            try (BufferedReader reader = Files.newBufferedReader(file, charset);){
                while ((line = reader.readLine()) != null) {
                    Triple trev;
                    if (++lineCounter % 1000000L == 0L) {
                        System.out.println(">>> parsed " + lineCounter + " lines");
                    }
                    if (line.length() <= 2) continue;
                    String[] token = line.split("\t");
                    if (token.length < 3) {
                        token = line.split(" ");
                    }
                    Triple t = null;
                    if (token.length == 3) {
                        t = new Triple(token[0], token[1], token[2]);
                    }
                    if (token.length == 4) {
                        if (token[3].equals(".")) {
                            t = new Triple(token[0], token[1], token[2]);
                        } else {
                            try {
                                t = new AnnotatedTriple(token[0], token[1], token[2]);
                                ((AnnotatedTriple)t).setConfidence(Double.parseDouble(token[3]));
                            }
                            catch (NumberFormatException nfe) {
                                System.err.println("could not parse line " + line);
                                t = null;
                            }
                        }
                    }
                    if (t == null) continue;
                    this.triples.add(t);
                    if (!Settings.REWRITE_REFLEXIV || !t.getTail().equals("me_myself_i")) continue;
                    if (!(t instanceof AnnotatedTriple)) {
                        trev = new Triple(t.getTail(), t.getRelation(), t.getHead());
                    } else {
                        trev = new AnnotatedTriple(t.getTail(), t.getRelation(), t.getHead());
                        ((AnnotatedTriple)trev).setConfidence(t.getConfidence());
                    }
                    this.triples.add(trev);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException x) {
            System.err.format("IOException: %s%n", x);
            System.err.format("Error occured for line: " + line + " LINE END", new Object[0]);
        }
        System.out.println("* read " + this.triples.size() + " triples");
    }

    public ArrayList<Triple> getTriples() {
        return this.triples;
    }

    public HashMap<AnnotatedTriple, Double> getAnnotatedTriples() {
        return this.atriples;
    }

    public ArrayList<Triple> getTriplesByHead(String head) {
        if (this.headToList.containsKey(head)) {
            return this.headToList.get(head);
        }
        return new ArrayList<Triple>();
    }

    public ArrayList<Triple> getNTriplesByHead(String head, int n) {
        if (this.headToList.containsKey(head)) {
            if (this.headToList.get(head).size() <= n) {
                return this.headToList.get(head);
            }
            ArrayList<Triple> chosen = new ArrayList<Triple>();
            int i = 0;
            while (i < n) {
                int index = this.rand.nextInt(this.headToList.get(head).size());
                chosen.add(this.headToList.get(head).get(index));
                ++i;
            }
            return chosen;
        }
        return new ArrayList<Triple>();
    }

    public ArrayList<Triple> getTriplesByTail(String tail) {
        if (this.tailToList.containsKey(tail)) {
            return this.tailToList.get(tail);
        }
        return new ArrayList<Triple>();
    }

    public ArrayList<Triple> getNTriplesByTail(String tail, int n) {
        if (this.tailToList.containsKey(tail)) {
            if (this.tailToList.get(tail).size() <= n) {
                return this.tailToList.get(tail);
            }
            ArrayList<Triple> chosen = new ArrayList<Triple>();
            int i = 0;
            while (i < n) {
                int index = this.rand.nextInt(this.tailToList.get(tail).size());
                chosen.add(this.tailToList.get(tail).get(index));
                ++i;
            }
            return chosen;
        }
        return new ArrayList<Triple>();
    }

    public ArrayList<Triple> getTriplesByRelation(String relation) {
        if (this.relationToList.containsKey(relation)) {
            return this.relationToList.get(relation);
        }
        return new ArrayList<Triple>();
    }

    public Triple getRandomTripleByRelation(String relation) {
        if (this.relationToList.containsKey(relation)) {
            return this.relationToList.get(relation).get(this.rand.nextInt(this.relationToList.get(relation).size()));
        }
        return null;
    }

    public ArrayList<String> getNRandomEntitiesByRelation(String relation, boolean headNotTail, int n) {
        if (headNotTail) {
            if (this.relation2HeadSample.containsKey(relation)) {
                return this.relation2HeadSample.get(relation);
            }
        } else if (this.relation2TailSample.containsKey(relation)) {
            return this.relation2TailSample.get(relation);
        }
        return this.computeNRandomEntitiesByRelation(relation, headNotTail, n);
    }

    private synchronized ArrayList<String> computeNRandomEntitiesByRelation(String relation, boolean headNotTail, int n) {
        if (this.relationToList.containsKey(relation)) {
            ArrayList<String> entities = new ArrayList<String>();
            HashSet<String> entitiesAsSet = new HashSet<String>();
            for (Triple triple : this.relationToList.get(relation)) {
                String value = triple.getValue(headNotTail);
                if (entitiesAsSet.contains(value)) continue;
                entitiesAsSet.add(value);
                entities.add(value);
            }
            ArrayList<String> sampledEntities = new ArrayList<String>();
            int i = 0;
            while (i < n) {
                String entity = (String)entities.get(this.rand.nextInt(entities.size()));
                sampledEntities.add(entity);
                ++i;
            }
            if (headNotTail) {
                this.relation2HeadSample.put(relation, sampledEntities);
            } else {
                this.relation2TailSample.put(relation, sampledEntities);
            }
            return sampledEntities;
        }
        System.err.println("something is strange, internal reference to relation " + relation + ", which is not indexed");
        System.err.println("check if rule set and triple set fit together");
        return null;
    }

    public Set<String> getRelations() {
        return this.relationToList.keySet();
    }

    public Set<String> getHeadEntities(String relation, String tail) {
        if (this.tailRelation2Head.get(tail) != null && this.tailRelation2Head.get(tail).get(relation) != null) {
            return this.tailRelation2Head.get(tail).get(relation);
        }
        return new HashSet<String>();
    }

    public Set<String> getTailEntities(String relation, String head) {
        if (this.headRelation2Tail.get(head) != null && this.headRelation2Tail.get(head).get(relation) != null) {
            return this.headRelation2Tail.get(head).get(relation);
        }
        return new HashSet<String>();
    }

    public Set<String> getEntities(String relation, String value, boolean headNotTail) {
        if (headNotTail) {
            return this.getTailEntities(relation, value);
        }
        return this.getHeadEntities(relation, value);
    }

    public String getRandomEntity(String relation, String value, boolean headNotTail) {
        if (headNotTail) {
            return this.getRandomTailEntity(relation, value);
        }
        return this.getRandomHeadEntity(relation, value);
    }

    private String getRandomHeadEntity(String relation, String tail) {
        if (!this.tailRelation2HeadList.containsKey(tail)) {
            return null;
        }
        ArrayList<String> list = this.tailRelation2HeadList.get(tail).get(relation);
        if (list == null) {
            return null;
        }
        return list.get(this.rand.nextInt(list.size()));
    }

    private String getRandomTailEntity(String relation, String head) {
        if (!this.headRelation2TailList.containsKey(head)) {
            return null;
        }
        ArrayList<String> list = this.headRelation2TailList.get(head).get(relation);
        if (list == null) {
            return null;
        }
        return list.get(this.rand.nextInt(list.size()));
    }

    public Set<String> getRelations(String head, String tail) {
        if (this.headTail2Relation.get(head) != null && this.headTail2Relation.get(head).get(tail) != null) {
            return this.headTail2Relation.get(head).get(tail);
        }
        return new HashSet<String>();
    }

    public boolean isTrue(String head, String relation, String tail) {
        if (this.tailRelation2Head.get(tail) != null && this.tailRelation2Head.get(tail).get(relation) != null) {
            return this.tailRelation2Head.get(tail).get(relation).contains(head);
        }
        return false;
    }

    public boolean isTrue(Triple triple) {
        return this.isTrue(triple.getHead(), triple.getRelation(), triple.getTail());
    }

    public double getConfidence(Triple t) {
        if (this.isTrue(t)) {
            return 1.0;
        }
        if (this.atriples.containsKey(t)) {
            return this.atriples.get(t);
        }
        return 0.0;
    }

    public void compareTo(TripleSet that, String thisId, String thatId) {
        System.out.println("* Comparing two triple sets");
        int counter = 0;
        for (Triple t : this.triples) {
            if (!that.isTrue(t)) continue;
            ++counter;
        }
        System.out.println("* size of " + thisId + ": " + this.triples.size());
        System.out.println("* size of " + thatId + ": " + that.triples.size());
        System.out.println("* size of intersection: " + counter);
    }

    public TripleSet getIntersectionWith(TripleSet that) {
        TripleSet ts = new TripleSet();
        for (Triple t : this.triples) {
            if (!that.isTrue(t)) continue;
            ts.addTriple(t);
        }
        return ts;
    }

    public TripleSet minus(TripleSet that) {
        TripleSet ts = new TripleSet();
        for (Triple t : this.triples) {
            if (that.isTrue(t)) continue;
            ts.addTriple(t);
        }
        return ts;
    }

    public int getNumOfEntities() {
        return this.headToList.keySet().size() + this.tailToList.keySet().size();
    }

    public void determineFrequentRelations(double coverage) {
        HashMap<String, Integer> relationCounter = new HashMap<String, Integer>();
        int allCounter = 0;
        for (Triple t : this.triples) {
            ++allCounter;
            String r = t.getRelation();
            if (relationCounter.containsKey(r)) {
                int count = (Integer)relationCounter.get(r);
                relationCounter.put(r, count + 1);
                continue;
            }
            relationCounter.put(r, 1);
        }
        ArrayList counts = new ArrayList();
        counts.addAll(relationCounter.values());
        Collections.sort(counts);
        int countUp = 0;
        int border = 0;
        for (Integer c : counts) {
            if (!((double)(allCounter - (countUp += c.intValue())) / (double)allCounter < coverage)) continue;
            border = c;
            break;
        }
        for (String r : relationCounter.keySet()) {
            if ((Integer)relationCounter.get(r) <= border) continue;
            this.frequentRelations.add(r);
        }
    }

    public boolean isFrequentRelation(String relation) {
        return this.frequentRelations.contains(relation);
    }

    public boolean existsPath(String x, String y, int pathLength) {
        if (pathLength == 1) {
            if (this.getRelations(x, y).size() > 0) {
                return true;
            }
            return this.getRelations(y, x).size() > 0;
        }
        if (pathLength == 2) {
            HashSet<String> hop1x = new HashSet<String>();
            for (Triple hx : this.getTriplesByHead(x)) {
                hop1x.add(hx.getTail());
            }
            for (Triple tx : this.getTriplesByTail(x)) {
                hop1x.add(tx.getHead());
            }
            for (Triple hy : this.getTriplesByHead(y)) {
                if (!hop1x.contains(hy.getTail())) continue;
                return true;
            }
            for (Triple ty : this.getTriplesByTail(y)) {
                if (!hop1x.contains(ty.getHead())) continue;
                return true;
            }
            return false;
        }
        if (pathLength > 2) {
            System.err.println("checking the existence of a path longer than 2 is so far not supported");
            System.exit(-1);
        }
        return false;
    }

    public Set<String> getEntities() {
        HashSet<String> entities = new HashSet<String>();
        entities.addAll(this.headToList.keySet());
        entities.addAll(this.tailToList.keySet());
        return entities;
    }

    public void write(String filepath) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(filepath);
        for (Triple triple : this.triples) {
            pw.println(triple);
        }
        for (Triple triple : this.atriples.keySet()) {
            pw.println(triple);
        }
        pw.flush();
        pw.close();
    }

    public int size() {
        return this.triples.size() + this.atriples.size();
    }
}

