/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.eval;

import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.eval.GoldStandard;
import de.unima.ki.anyburl.eval.HitsAtK;
import de.unima.ki.anyburl.eval.ResultSet;
import java.io.IOException;
import java.util.ArrayList;

public class AggregateEvaluation {
    public static String[] categories = new String[]{"Symmetry", "Equivalence", "Subsumption", "Path", "Not covered"};
    public static String target = "FB15";
    public static int ALL_HEAD_TAIL = 0;

    public static void main(String[] args) throws IOException {
        TripleSet trainingSet = null;
        TripleSet validationSet = null;
        TripleSet testSet = null;
        GoldStandard gold = null;
        if (target.equals("WN18")) {
            trainingSet = new TripleSet("data/WN18/train.txt");
            validationSet = new TripleSet("data/WN18/valid.txt");
            testSet = new TripleSet("data/WN18/test.txt");
            gold = new GoldStandard("data/WN18/gold.txt");
        }
        if (target.equals("FB15")) {
            trainingSet = new TripleSet("data/FB15k/train.txt");
            validationSet = new TripleSet("data/FB15k/valid.txt");
            testSet = new TripleSet("data/FB15k/test.txt");
            gold = new GoldStandard("data/FB15k/gold.txt");
        }
        if (target.equals("FB15-237")) {
            trainingSet = new TripleSet("data/FB15-237/train.txt");
            validationSet = new TripleSet("data/FB15-237/valid.txt");
            testSet = new TripleSet("data/FB15-237/test.txt");
            gold = new GoldStandard("data/FB15-237/gold.txt");
        }
        if (target.equals("WN18RR")) {
            trainingSet = new TripleSet("data/WN18RR/train.txt");
            validationSet = new TripleSet("data/WN18RR/valid.txt");
            testSet = new TripleSet("data/WN18RR/test.txt");
        }
        if (target.equals("YAGO")) {
            trainingSet = new TripleSet("data/YAGO03-10/train.txt");
            validationSet = new TripleSet("data/YAGO03-10/valid.txt");
            testSet = new TripleSet("data/YAGO03-10/test.txt");
            gold = null;
        }
        if (target.equals("DB500")) {
            trainingSet = new TripleSet("data/DB500/train.txt");
            validationSet = new TripleSet("data/DB500/valid.txt");
            testSet = new TripleSet("data/DB500/test.txt");
            gold = null;
        }
        if (target.equals("ASS")) {
            trainingSet = new TripleSet("experiments/SemAssocs/data/empty.txt");
            validationSet = new TripleSet("experiments/SemAssocs/data/empty.txt");
            testSet = new TripleSet("experiments/SemAssocs/data/assoc_test.nt");
            gold = null;
        }
        if (target.equals("MOB")) {
            trainingSet = new TripleSet("data/mob/train.txt");
            validationSet = new TripleSet("data/mob/valid.txt");
            testSet = new TripleSet("data/mob/test.txt");
            gold = null;
        }
        if (target.equals("WD")) {
            trainingSet = new TripleSet("data/WIKIDATA/empty.txt");
            validationSet = new TripleSet("data/WIKIDATA/empty.txt");
            testSet = new TripleSet("data/WIKIDATA/test.txt");
            gold = null;
        }
        ResultSet[] results = null;
        boolean html = false;
        if (target.equals("ASS")) {
            results = new ResultSet[]{new ResultSet("RuleN", "experiments/SemAssocs/predictions/p12-s200.txt", true, 100), new ResultSet("RuleN", "experiments/SemAssocs/predictions/p12-s200-mul.txt", true, 100), new ResultSet("RuleN", "experiments/SemAssocs/predictions/p123-s200.txt", true, 100), new ResultSet("RuleN", "experiments/SemAssocs/predictions/p123-s500.txt", true, 100)};
        }
        if (target.equals("WD")) {
            results = new ResultSet[]{new ResultSet("500      ", "exp/february/final/rg/wikidata-rt-c2a1g1-p1s1-predictionsZ-AVG-500", true, 10), new ResultSet("1000     ", "exp/february/final/rg/wikidata-rt-c2a1g1-p1s1-predictionsZ-AVG-1000", true, 10), new ResultSet("5000     ", "exp/february/final/rg/wikidata-rt-c2a1g1-p1s1-predictionsZ-AVG-5000", true, 10), new ResultSet("10000    ", "exp/february/final/rg/wikidata-rt-c2a1g1-p1s1-predictionsZ-AVG-10000", true, 10)};
        }
        if (target.equals("MOB")) {
            results = new ResultSet[]{new ResultSet("RuleN", "exp/summer/mob/mob-rules-pred-100", true, 100)};
        }
        if (target.equals("WN18")) {
            results = new ResultSet[]{new ResultSet("100    5    ", "exp/february/final/free/wn18-c5a1g1-p1s1-preds-100", true, 10), new ResultSet("500    5    ", "exp/february/final/free/wn18-c5a1g1-p1s1-preds-500", true, 10), new ResultSet("1000   5    ", "exp/february/final/free/wn18-c5a1g1-p1s1-preds-1000", true, 10), new ResultSet("5000   5    ", "exp/february/final/free/wn18-c5a1g1-p1s1-preds-5000", true, 10), new ResultSet("10000  5    ", "exp/february/final/free/wn18-c5a1g1-p1s1-preds-10000", true, 10)};
        }
        if (target.equals("WN18RR")) {
            ResultSet[] resultSetArray = new ResultSet[6];
            resultSetArray[0] = new ResultSet("100   5     ", "exp/february/final/free/wn18rr-c5a1g1-p1s1-preds-100", true, 10);
            resultSetArray[1] = new ResultSet("500   5     ", "exp/february/final/free/wn18rr-c5a1g1-p1s1-preds-500", true, 10);
            resultSetArray[2] = new ResultSet("1000  5     ", "exp/february/final/free/wn18rr-c5a1g1-p1s1-preds-1000", true, 10);
            resultSetArray[3] = new ResultSet("5000  5     ", "exp/february/final/free/wn18rr-c5a1g1-p1s1-preds-5000", true, 10);
            resultSetArray[4] = new ResultSet("10000 5     ", "exp/february/final/free/wn18rr-c5a1g1-p1s1-preds-10000", true, 10);
            results = resultSetArray;
        }
        if (target.equals("YAGO")) {
            ResultSet[] resultSetArray = new ResultSet[16];
            resultSetArray[0] = new ResultSet("p2s5   49", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-49", true, 10);
            resultSetArray[1] = new ResultSet("p2s5   51", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-51", true, 10);
            resultSetArray[2] = new ResultSet("p2s5   50", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-50", true, 10);
            resultSetArray[4] = new ResultSet("p2s5   99", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-99", true, 10);
            resultSetArray[5] = new ResultSet("p2s5  101", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-101", true, 10);
            resultSetArray[6] = new ResultSet("p2s5  100", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-100", true, 10);
            resultSetArray[8] = new ResultSet("p2s5  449", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-499", true, 10);
            resultSetArray[9] = new ResultSet("p2s5  501", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-501", true, 10);
            resultSetArray[10] = new ResultSet("p2s5  500", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-500", true, 10);
            resultSetArray[12] = new ResultSet("p2s5  999", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-999", true, 10);
            resultSetArray[13] = new ResultSet("p2s5 1001", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-1001", true, 10);
            resultSetArray[14] = new ResultSet("p2s5 1000", "exp/february/ext/yagoxxx-c3a1-p2s5-predictions-1000", true, 10);
            results = resultSetArray;
        }
        if (target.equals("DB500")) {
            results = new ResultSet[]{new ResultSet("100     ", "exp/january/reinforced/db500-predictions-100", true, 10)};
        }
        if (target.equals("FB15-237")) {
            ResultSet[] resultSetArray = new ResultSet[16];
            resultSetArray[0] = new ResultSet("p2s5   49", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-49", true, 10);
            resultSetArray[1] = new ResultSet("p2s5   51", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-51", true, 10);
            resultSetArray[2] = new ResultSet("p2s5   50", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-50", true, 10);
            resultSetArray[4] = new ResultSet("p2s5   99", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-99", true, 10);
            resultSetArray[5] = new ResultSet("p2s5  101", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-101", true, 10);
            resultSetArray[6] = new ResultSet("p2s5  100", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-100", true, 10);
            resultSetArray[8] = new ResultSet("p2s5  449", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-499", true, 10);
            resultSetArray[9] = new ResultSet("p2s5  501", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-501", true, 10);
            resultSetArray[10] = new ResultSet("p2s5  500", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-500", true, 10);
            resultSetArray[12] = new ResultSet("p2s5  999", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-999", true, 10);
            resultSetArray[13] = new ResultSet("p2s5 1001", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-1001", true, 10);
            resultSetArray[14] = new ResultSet("p2s5 1000", "exp/february/ext/fb237xxx-c3a1-p2s5-predictions-1000", true, 10);
            results = resultSetArray;
        }
        if (target.equals("FB15")) {
            ResultSet[] resultSetArray = new ResultSet[22];
            resultSetArray[0] = new ResultSet("p2s5   49", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-49", true, 10);
            resultSetArray[1] = new ResultSet("p2s5   51", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-51", true, 10);
            resultSetArray[2] = new ResultSet("p2s5   50", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-50", true, 10);
            resultSetArray[3] = new ResultSet("p2s5   49", "exp/february/ext/fb15yyy-c3a1-p2s5-predictions-49", true, 10);
            resultSetArray[4] = new ResultSet("p2s5   51", "exp/february/ext/fb15yyy-c3a1-p2s5-predictions-51", true, 10);
            resultSetArray[5] = new ResultSet("p2s5   50", "exp/february/ext/fb15yyy-c3a1-p2s5-predictions-50", true, 10);
            resultSetArray[7] = new ResultSet("p2s5   99", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-99", true, 10);
            resultSetArray[8] = new ResultSet("p2s5  101", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-101", true, 10);
            resultSetArray[9] = new ResultSet("p2s5  100", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-100", true, 10);
            resultSetArray[10] = new ResultSet("p2s5   99", "exp/february/ext/fb15yyy-c3a1-p2s5-predictions-99", true, 10);
            resultSetArray[11] = new ResultSet("p2s5  101", "exp/february/ext/fb15yyy-c3a1-p2s5-predictions-101", true, 10);
            resultSetArray[12] = new ResultSet("p2s5  100", "exp/february/ext/fb15yyy-c3a1-p2s5-predictions-100", true, 10);
            resultSetArray[14] = new ResultSet("p2s5  449", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-499", true, 10);
            resultSetArray[15] = new ResultSet("p2s5  501", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-501", true, 10);
            resultSetArray[16] = new ResultSet("p2s5  500", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-500", true, 10);
            resultSetArray[18] = new ResultSet("p2s5  999", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-999", true, 10);
            resultSetArray[19] = new ResultSet("p2s5 1001", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-1001", true, 10);
            resultSetArray[20] = new ResultSet("p2s5 1000", "exp/february/ext/fb15xxx-c3a1-p2s5-predictions-1000", true, 10);
            results = resultSetArray;
        }
        HitsAtK hitsAtK = new HitsAtK();
        hitsAtK.addFilterTripleSet(trainingSet);
        hitsAtK.addFilterTripleSet(validationSet);
        hitsAtK.addFilterTripleSet(testSet);
        GoldStandard goldSymmetry = null;
        GoldStandard goldEquivalence = null;
        GoldStandard goldSubsumption = null;
        GoldStandard goldPath = null;
        GoldStandard goldUncovered = null;
        if (gold != null) {
            goldSymmetry = gold.getSubset("Symmetry");
            goldEquivalence = gold.getSubset("Equivalence");
            goldSubsumption = gold.getSubset("Subsumption");
            goldPath = gold.getSubset("Path");
            goldUncovered = gold.getSubset("Not covered");
        }
        double hitsAT1All = 0.0;
        double hitsAT10All = 0.0;
        String resultName = "";
        int resultCounter = 0;
        ResultSet[] resultSetArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ResultSet rs = resultSetArray[n2];
            if (rs == null) {
                double hitsAT1 = hitsAT1All / (double)resultCounter;
                double hitsAT10 = hitsAT10All / (double)resultCounter;
                System.out.println(String.valueOf(resultName) + "\t" + HitsAtK.f(hitsAT1) + "\t" + HitsAtK.f(hitsAT10));
                hitsAT1All = 0.0;
                hitsAT10All = 0.0;
                resultCounter = 0;
            } else {
                AggregateEvaluation.computeScores(rs, testSet, hitsAtK);
                hitsAT1All += hitsAtK.getHitsAtKDouble(0);
                hitsAT10All += hitsAtK.getHitsAtKDouble(9);
                resultName = rs.getName();
                ++resultCounter;
                hitsAtK.reset();
            }
            ++n2;
        }
    }

    private static void computeScores(ResultSet rs, GoldStandard gold, HitsAtK hitsAtK) {
        int counter = 21;
        for (String triple : gold.triples) {
            ArrayList<String> cand;
            String[] tt = triple.split(" ");
            Triple t = new Triple(tt[0], tt[1], tt[2]);
            if (gold.getCategory(triple, true) != null) {
                ++counter;
                cand = rs.getHeadCandidates(triple);
                hitsAtK.evaluateHead(cand, t);
            }
            if (gold.getCategory(triple, false) == null) continue;
            ++counter;
            cand = rs.getTailCandidates(triple);
            hitsAtK.evaluateTail(cand, t);
        }
    }

    private static void computeScores(ResultSet rs, TripleSet gold, HitsAtK hitsAtK) {
        for (Triple t : gold.getTriples()) {
            if (!target.equals("ASS")) {
                ArrayList<String> cand1 = rs.getHeadCandidates(t.toString());
                String c1 = cand1.size() > 0 ? cand1.get(0) : "-";
                hitsAtK.evaluateHead(cand1, t);
            }
            ArrayList<String> cand2 = rs.getTailCandidates(t.toString());
            hitsAtK.evaluateTail(cand2, t);
        }
    }

    private static void printAndMarkUnfoundTriples(ResultSet rs, GoldStandard gold, HitsAtK hitsAtK) {
        for (String triple : gold.triples) {
            int foundAt;
            String c;
            ArrayList<String> cand;
            String[] tt = triple.split(" ");
            Triple t = new Triple(tt[0], tt[1], tt[2]);
            if (gold.getCategory(triple, true) != null) {
                cand = rs.getHeadCandidates(triple);
                c = cand.size() > 0 ? cand.get(0) : "-";
                foundAt = hitsAtK.evaluateHead(cand, t);
                if (foundAt < 0) {
                    System.out.println(String.valueOf(t.getHead()) + " headX" + t.getRelation() + " " + t.getTail());
                }
            }
            if (gold.getCategory(triple, false) == null) continue;
            cand = rs.getTailCandidates(triple);
            c = cand.size() > 0 ? cand.get(0) : "-";
            foundAt = hitsAtK.evaluateTail(cand, t);
            if (foundAt >= 0) continue;
            System.out.println(String.valueOf(t.getHead()) + " tailX" + t.getRelation() + " " + t.getTail());
        }
    }

    private static void compareResultSets(ResultSet rs1, ResultSet rs2, GoldStandard gold, HitsAtK hitsAtK) {
        for (String triple : gold.triples) {
            boolean foundBy2;
            boolean foundBy1;
            ArrayList<String> cand2;
            ArrayList<String> cand1;
            String[] tt = triple.split(" ");
            Triple t = new Triple(tt[0], tt[1], tt[2]);
            if (gold.getCategory(triple, true) != null) {
                cand1 = rs1.getHeadCandidates(triple);
                cand2 = rs2.getHeadCandidates(triple);
                foundBy1 = false;
                for (String c1 : cand1) {
                    if (!t.getHead().equals(c1)) continue;
                    foundBy1 = true;
                }
                foundBy2 = false;
                for (String string : cand2) {
                    if (!t.getHead().equals(string)) continue;
                    foundBy2 = true;
                }
                if (foundBy1 != foundBy2) {
                    System.out.println("H " + rs1.getName() + "=" + foundBy1 + " " + rs2.getName() + "=" + foundBy2 + " " + triple);
                }
            }
            if (gold.getCategory(triple, false) == null) continue;
            cand1 = rs1.getTailCandidates(triple);
            cand2 = rs2.getTailCandidates(triple);
            foundBy1 = false;
            for (String c1 : cand1) {
                if (!t.getTail().equals(c1)) continue;
                foundBy1 = true;
            }
            foundBy2 = false;
            for (String string : cand2) {
                if (!t.getTail().equals(string)) continue;
                foundBy2 = true;
            }
            if (foundBy1 == foundBy2) continue;
            System.out.println("T " + rs1.getName() + "=" + foundBy1 + " " + rs2.getName() + "=" + foundBy2 + " " + triple);
        }
    }
}

