/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.eval;

import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.eval.Candidate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.PriorityQueue;

public class CompletionResult {
    private ArrayList<String> headResults;
    private ArrayList<String> tailResults;
    private ArrayList<Double> headConfidences;
    private ArrayList<Double> tailConfidences;
    private String triple;

    public CompletionResult(String triple) {
        this.triple = triple;
        this.headResults = new ArrayList();
        this.tailResults = new ArrayList();
        this.headConfidences = new ArrayList();
        this.tailConfidences = new ArrayList();
    }

    public void addHeadResults(String[] heads, int k) {
        if (k > 0) {
            this.addResults(heads, this.headResults, k);
        } else {
            this.addResults(heads, this.headResults);
        }
    }

    public void addTailResults(String[] tails, int k) {
        if (k > 0) {
            this.addResults(tails, this.tailResults, k);
        } else {
            this.addResults(tails, this.tailResults);
        }
    }

    private void addResults(String[] candidates, ArrayList<String> results, int k) {
        String[] stringArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (!c.equals("")) {
                results.add(c);
                if (--k == 0) {
                    return;
                }
            }
            ++n2;
        }
    }

    private void addConfidences(Double[] confs, ArrayList<Double> confidences) {
        Double[] doubleArray = confs;
        int n = confs.length;
        int n2 = 0;
        while (n2 < n) {
            Double d = doubleArray[n2];
            confidences.add(d);
            ++n2;
        }
    }

    private void addConfidences(Double[] confs, ArrayList<Double> confidences, int k) {
        Double[] doubleArray = confs;
        int n = confs.length;
        int n2 = 0;
        while (n2 < n) {
            Double d = doubleArray[n2];
            confidences.add(d);
            if (--k == 0) {
                return;
            }
            ++n2;
        }
    }

    private void addResults(String[] candidates, ArrayList<String> results) {
        String[] stringArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (!c.equals("")) {
                results.add(c);
            }
            ++n2;
        }
    }

    public ArrayList<String> getHeads() {
        return this.headResults;
    }

    public ArrayList<String> getTails() {
        return this.tailResults;
    }

    public ArrayList<Double> getHeadConfidences() {
        return this.headConfidences;
    }

    public ArrayList<Double> getTailConfidences() {
        return this.tailConfidences;
    }

    public void addHeadConfidences(Double[] confidences, int k) {
        if (k > 0) {
            this.addConfidences(confidences, this.headConfidences, k);
        } else {
            this.addConfidences(confidences, this.headConfidences);
        }
    }

    public void addTailConfidences(Double[] confidences, int k) {
        if (k > 0) {
            this.addConfidences(confidences, this.tailConfidences, k);
        } else {
            this.addConfidences(confidences, this.tailConfidences);
        }
    }

    public void extendWith(CompletionResult thatResult, int k, double factor) {
        Candidate hc;
        Candidate hc2;
        PriorityQueue<Candidate> qHeads = new PriorityQueue<Candidate>();
        HashMap<String, Double> headsC = new HashMap<String, Double>();
        int i = 0;
        while (i < this.headConfidences.size()) {
            hc2 = new Candidate(this.getHeads().get(i), this.headConfidences.get(i));
            qHeads.add(hc2);
            headsC.put(this.getHeads().get(i), this.headConfidences.get(i));
            ++i;
        }
        i = 0;
        while (i < thatResult.headConfidences.size()) {
            hc2 = new Candidate(thatResult.getHeads().get(i), thatResult.headConfidences.get(i) * factor);
            if (headsC.containsKey(thatResult.getHeads().get(i))) {
                if (hc2.confidence > (Double)headsC.get(thatResult.getHeads().get(i))) {
                    System.out.println(hc2.confidence);
                    qHeads.remove(hc2);
                    qHeads.add(hc2);
                }
            } else {
                qHeads.add(hc2);
            }
            ++i;
        }
        this.headResults.clear();
        this.headConfidences.clear();
        int j = 0;
        while (qHeads.size() > 0) {
            Candidate c = (Candidate)qHeads.poll();
            this.headResults.add(c.value);
            this.headConfidences.add(c.confidence);
            if (++j == k) break;
        }
        PriorityQueue<Candidate> qTails = new PriorityQueue<Candidate>();
        HashMap<String, Double> tailsC = new HashMap<String, Double>();
        int i2 = 0;
        while (i2 < this.tailConfidences.size()) {
            hc = new Candidate(this.getTails().get(i2), this.tailConfidences.get(i2));
            qTails.add(hc);
            tailsC.put(this.getTails().get(i2), this.tailConfidences.get(i2));
            ++i2;
        }
        i2 = 0;
        while (i2 < thatResult.tailConfidences.size()) {
            hc = new Candidate(thatResult.getTails().get(i2), thatResult.tailConfidences.get(i2) * factor);
            if (tailsC.containsKey(thatResult.getTails().get(i2))) {
                if (hc.confidence > (Double)tailsC.get(thatResult.getTails().get(i2))) {
                    qTails.remove(hc);
                    qTails.add(hc);
                }
            } else {
                qTails.add(hc);
            }
            ++i2;
        }
        this.tailResults.clear();
        this.tailConfidences.clear();
        j = 0;
        while (qTails.size() > 0) {
            Candidate c = (Candidate)qTails.poll();
            this.tailResults.add(c.value);
            this.tailConfidences.add(c.confidence);
            if (++j == k) break;
        }
    }

    public void supressConnected(TripleSet triples) {
        String[] token = this.triple.split(" ");
        String head = token[0];
        String relation = token[1];
        String tail = token[2];
        int i = 0;
        while (i < this.tailResults.size()) {
            if (triples.getRelations(head, this.tailResults.get(i)).size() > 0) {
                System.out.println("remove head candidate " + this.tailResults.get(i));
                this.tailResults.remove(i);
                this.tailConfidences.remove(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.headResults.size()) {
            if (triples.getRelations(this.headResults.get(i), tail).size() > 0) {
                System.out.println("remove tail candidate " + this.headResults.get(i));
                this.headResults.remove(i);
                this.headConfidences.remove(i);
            }
            ++i;
        }
    }
}

