/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.eval;

import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.eval.CompletionResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;

public class ResultSet {
    private HashMap<String, CompletionResult> results;
    private String name;
    public static boolean applyThreshold = false;
    public static double threshold = 0.0;
    private boolean containsConfidences = false;

    public static void main(String[] args) throws FileNotFoundException {
        ResultSet rs = new ResultSet("exp/january/reinforced/db500-predictions-100", true, 10);
    }

    public ResultSet(String name, String filePath) {
        this(name, filePath, false, 0);
    }

    public ResultSet(String name, boolean containsConfidences, int k) {
        this(name, name, containsConfidences, k);
    }

    public ResultSet(String name, String filePath, boolean containsConfidences, int k) {
        System.out.println("* loading result set at " + filePath);
        this.containsConfidences = containsConfidences;
        this.name = name;
        this.results = new HashMap();
        long counter = 0L;
        long stepsize = 100000L;
        File file = null;
        try {
            String tripleLine;
            file = new File(filePath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
            while ((tripleLine = bufferedReader.readLine()) != null) {
                if (++counter % stepsize == 0L) {
                    System.out.println("* parsed " + counter + " lines of results file");
                }
                if (tripleLine.length() < 3) continue;
                CompletionResult cr = new CompletionResult(tripleLine);
                String headLine = bufferedReader.readLine();
                String tailLine = bufferedReader.readLine();
                String tempLine = "";
                if (headLine.startsWith("Tails:")) {
                    System.out.println("reversed");
                    tempLine = headLine;
                    headLine = tailLine;
                    tailLine = tempLine;
                }
                if (!applyThreshold) {
                    cr.addHeadResults(this.getResultsFromLine(headLine.substring(7)), k);
                    cr.addHeadConfidences(this.getConfidencesFromLine(headLine.substring(7)), k);
                    cr.addTailResults(this.getResultsFromLine(tailLine.substring(7)), k);
                    cr.addTailConfidences(this.getConfidencesFromLine(tailLine.substring(7)), k);
                } else {
                    cr.addHeadResults(this.getThresholdedResultsFromLine(headLine.substring(7)), k);
                    cr.addHeadConfidences(this.getThresholdedConfidencesFromLine(headLine.substring(7)), k);
                    cr.addTailResults(this.getThresholdedResultsFromLine(tailLine.substring(7)), k);
                    cr.addTailConfidences(this.getThresholdedConfidencesFromLine(tailLine.substring(7)), k);
                }
                this.results.put(tripleLine.split("\t")[0], cr);
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            System.err.println("poblem related to file " + file + ".");
            e.printStackTrace();
        }
    }

    public void extendWith(ResultSet rs, int k, double factor) {
        for (String t : this.results.keySet()) {
            CompletionResult thisResult = this.results.get(t);
            CompletionResult thatResult = rs.results.get(t);
            thisResult.extendWith(thatResult, k, factor);
        }
    }

    public void printAsTripleSet(PrintWriter pw) {
        for (String line : this.results.keySet()) {
            String[] token = line.split("\\s+");
            CompletionResult cr = this.results.get(line);
            int i = 0;
            for (String h : cr.getHeads()) {
                if (i % 2 == 0) {
                    pw.println(String.valueOf(h) + " " + token[1] + " " + token[2]);
                }
                ++i;
            }
            i = 0;
            for (String t : cr.getTails()) {
                if (i % 2 == 0) {
                    pw.println(String.valueOf(token[0]) + " " + token[1] + " " + t);
                }
                ++i;
            }
        }
    }

    private String[] getThresholdedResultsFromLine(String rline) {
        if (!this.containsConfidences) {
            return rline.split("\t");
        }
        String t = "";
        String cS = "";
        String[] token = rline.split("\t");
        ArrayList<String> tokenx = new ArrayList<String>();
        int i = 0;
        while (i < token.length / 2) {
            t = token[i * 2];
            cS = token[i * 2 + 1];
            double c = Double.parseDouble(cS);
            if (!(c > threshold)) break;
            tokenx.add(t);
            ++i;
        }
        String[] tokenxx = tokenx.toArray(new String[0]);
        return tokenxx;
    }

    private Double[] getThresholdedConfidencesFromLine(String rline) {
        if (!this.containsConfidences) {
            System.err.println("there are no confidences, you cannot retrieve them");
            return null;
        }
        String t = "";
        String cS = "";
        String[] token = rline.split("\t");
        ArrayList<Double> tokenx = new ArrayList<Double>();
        int i = 0;
        while (i < token.length / 2) {
            cS = token[i * 2 + 1];
            double c = Double.parseDouble(cS);
            if (!(c > threshold)) break;
            tokenx.add(c);
            ++i;
        }
        Double[] tokenxx = tokenx.toArray(new Double[0]);
        return tokenxx;
    }

    private String[] getResultsFromLine(String rline) {
        if (!this.containsConfidences) {
            return rline.split("\t");
        }
        String[] token = rline.split("\t");
        String[] tokenx = new String[token.length / 2];
        int i = 0;
        while (i < tokenx.length) {
            tokenx[i] = token[i * 2];
            ++i;
        }
        return tokenx;
    }

    private Double[] getConfidencesFromLine(String rline) {
        if (!this.containsConfidences) {
            System.err.println("there are no confidences, you cannot retrieve them");
            return null;
        }
        String[] token = rline.split("\t");
        Double[] tokenx = new Double[token.length / 2];
        int i = 0;
        while (i < tokenx.length) {
            tokenx[i] = Double.parseDouble(token[i * 2 + 1]);
            ++i;
        }
        return tokenx;
    }

    public ArrayList<String> getHeadCandidates(String triple) {
        try {
            CompletionResult cr = this.results.get(triple);
            return cr.getHeads();
        }
        catch (RuntimeException e) {
            return new ArrayList<String>();
        }
    }

    public ArrayList<String> getTailCandidates(String triple) {
        try {
            CompletionResult cr = this.results.get(triple);
            return cr.getTails();
        }
        catch (RuntimeException e) {
            return new ArrayList<String>();
        }
    }

    public ArrayList<Double> getHeadConfidences(String triple) {
        try {
            CompletionResult cr = this.results.get(triple);
            return cr.getHeadConfidences();
        }
        catch (RuntimeException e) {
            return new ArrayList<Double>();
        }
    }

    public ArrayList<Double> getTailConfidences(String triple) {
        try {
            CompletionResult cr = this.results.get(triple);
            return cr.getTailConfidences();
        }
        catch (RuntimeException e) {
            return new ArrayList<Double>();
        }
    }

    public String getName() {
        return this.name;
    }

    public void supressConnected(TripleSet trainingSet) {
        for (String triple : this.results.keySet()) {
            CompletionResult cr = this.results.get(triple);
            cr.supressConnected(trainingSet);
        }
    }
}

