/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.eval;

import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import java.util.Set;

public class TestHardnessEstimator {
    public static void main(String[] args) {
        TripleSet training = new TripleSet("data/FB15-237/train.txt");
        TripleSet test = new TripleSet("data/FB15-237/test.txt");
        TripleSet valid = new TripleSet("data/FB15-237/valid.txt");
        TripleSet all = new TripleSet();
        all.addTripleSet(training);
        all.addTripleSet(test);
        all.addTripleSet(valid);
        int[] headsCounter = new int[5];
        int[] tailsCounter = new int[5];
        double unknownRateHead = 0.1;
        double unknownRateTail = 0.1;
        double hitsAT1RateHead = 0.0;
        double hitsAT1RateTail = 0.0;
        for (Triple t : test.getTriples()) {
            String head = t.getHead();
            String tail = t.getTail();
            String relation = t.getRelation();
            Set<String> heads = all.getHeadEntities(relation, tail);
            Set<String> tails = all.getTailEntities(relation, head);
            double d1 = 1.0 / ((double)heads.size() * unknownRateHead);
            if (d1 >= 1.0) {
                d1 = 1.0;
            }
            hitsAT1RateHead += d1;
            double d2 = 1.0 / ((double)tails.size() * unknownRateTail);
            if (d2 >= 1.0) {
                d2 = 1.0;
            }
            hitsAT1RateTail += d2;
            if (heads.size() == 1) {
                headsCounter[0] = headsCounter[0] + 1;
            }
            if (heads.size() > 1 && heads.size() <= 10) {
                headsCounter[1] = headsCounter[1] + 1;
            }
            if (heads.size() > 10 && heads.size() <= 50) {
                headsCounter[2] = headsCounter[2] + 1;
            }
            if (heads.size() > 50 && heads.size() <= 200) {
                headsCounter[3] = headsCounter[3] + 1;
            }
            if (heads.size() > 200) {
                headsCounter[4] = headsCounter[4] + 1;
            }
            if (tails.size() == 1) {
                tailsCounter[0] = tailsCounter[0] + 1;
            }
            if (tails.size() > 1 && tails.size() <= 10) {
                tailsCounter[1] = tailsCounter[1] + 1;
            }
            if (tails.size() > 10 && tails.size() <= 50) {
                tailsCounter[2] = tailsCounter[2] + 1;
            }
            if (tails.size() > 50 && tails.size() <= 200) {
                tailsCounter[3] = tailsCounter[3] + 1;
            }
            if (tails.size() <= 200) continue;
            tailsCounter[4] = tailsCounter[4] + 1;
        }
        int allHeads = 0;
        int allTails = 0;
        int i = 0;
        while (i < 5) {
            allHeads += headsCounter[i];
            allTails += tailsCounter[i];
            ++i;
        }
        i = 0;
        while (i < 5) {
            System.out.print(String.valueOf((double)headsCounter[i] / (double)allHeads) + "\t");
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < 5) {
            System.out.print(String.valueOf((double)tailsCounter[i] / (double)allTails) + "\t");
            ++i;
        }
        System.out.println();
        System.out.println(String.valueOf(headsCounter[0]) + "\t" + headsCounter[1] + "\t" + headsCounter[2] + "\t" + headsCounter[3] + "\t" + (double)headsCounter[4] / (double)allTails);
        System.out.println(String.valueOf(tailsCounter[0]) + "\t" + tailsCounter[1] + "\t" + tailsCounter[2] + "\t" + tailsCounter[3] + "\t" + tailsCounter[4]);
        System.out.println("hitsAT1RateHead =     " + hitsAT1RateHead / (double)test.getTriples().size());
        System.out.println("hitsAT1RateTail =     " + hitsAT1RateTail / (double)test.getTriples().size());
        System.out.println("average hitsAT1Rate = " + (hitsAT1RateTail / (double)test.getTriples().size() + hitsAT1RateHead / (double)test.getTriples().size()) / 2.0);
    }
}

