/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.eval;

import de.unima.ki.anyburl.data.AnnotatedTriple;
import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class XRYEvaluation {
    public static void main(String[] args) throws IOException {
        TripleSet resultSet = new TripleSet("experiments/WN18/predictions/rl/p123-500.txt");
        TripleSet testSet = new TripleSet("data/WN18/test.txt");
        int K = 100;
        double weightedHitsATK = 0.0;
        double above = 0.0;
        double below = 0.0;
        double unweightedHitsATK = 0.0;
        Set<String> relations = resultSet.getRelations();
        int denominator = 0;
        for (String relation : relations) {
            int d = Math.min(K, testSet.getTriplesByRelation(relation).size());
            denominator += d;
        }
        int i = 0;
        double weightedMapATK = 0.0;
        double unweightedMapATK = 0.0;
        int tripleCounter = 0;
        double confidenceTotal = 0.0;
        for (String relation : relations) {
            System.out.print(relation);
            TripleSet tTriples = new TripleSet();
            for (Triple t : testSet.getTriplesByRelation(relation)) {
                tTriples.addTriple(t);
            }
            if (tTriples.getTriples().size() == 0) {
                System.out.println(" ...");
                continue;
            }
            TripleSet rTriples = new TripleSet();
            for (Triple t : resultSet.getTriplesByRelation(relation)) {
                rTriples.addTriple(t);
            }
            for (Triple t : rTriples.getTriples()) {
                AnnotatedTriple at = (AnnotatedTriple)t;
                confidenceTotal += at.getConfidence();
                ++tripleCounter;
            }
            TripleSet iTriples = tTriples.getIntersectionWith(rTriples);
            double hitsATK = (double)iTriples.getTriples().size() / (double)Math.min(K, tTriples.getTriples().size());
            double apATK = 0.0;
            apATK = XRYEvaluation.getAveragePrecision(tTriples, rTriples);
            unweightedMapATK += apATK;
            weightedMapATK += apATK * ((double)Math.min(K, tTriples.getTriples().size()) / (double)denominator);
            System.out.println(" hitsAtk=" + hitsATK + " apAtk=" + apATK + " test=" + tTriples.getTriples().size() + " result=" + rTriples.getTriples().size() + " intersection=" + iTriples.getTriples().size());
            above += (double)iTriples.getTriples().size();
            below += (double)Math.min(K, tTriples.getTriples().size());
            unweightedHitsATK += hitsATK;
            ++i;
        }
        weightedHitsATK = above / below;
        System.out.println("=============================================");
        System.out.println("Weighted Mean Hits@K:   " + weightedHitsATK);
        System.out.println("Unweighted Mean Hits@K: " + (unweightedHitsATK /= (double)i));
        System.out.println("Weighted MAP@K:         " + weightedMapATK);
        System.out.println("Unweighted MAP@K:       " + (unweightedMapATK /= (double)i));
        System.out.println("Confidence Average:     " + confidenceTotal / (double)tripleCounter);
    }

    private static double getAveragePrecision(TripleSet tTriples, TripleSet rTriples) {
        ArrayList<AnnotatedTriple> rTriplesAnnotated = new ArrayList<AnnotatedTriple>();
        for (Triple t : rTriples.getTriples()) {
            rTriplesAnnotated.add((AnnotatedTriple)t);
        }
        Collections.sort(rTriplesAnnotated);
        Collections.reverse(rTriplesAnnotated);
        int created = 1;
        int correct = 1;
        double ap = 0.0;
        for (AnnotatedTriple t : rTriplesAnnotated) {
            if (tTriples.isTrue(t)) {
                double p = (double)correct / (double)created;
                ap += p;
                ++correct;
            }
            ++created;
        }
        return ap / (double)correct;
    }
}

