/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.structure.Atom;
import de.unima.ki.anyburl.structure.Body;
import de.unima.ki.anyburl.structure.Negation;
import de.unima.ki.anyburl.structure.RuleAcyclic1;
import de.unima.ki.anyburl.structure.RuleAcyclic2;
import de.unima.ki.anyburl.structure.RuleCyclic;
import de.unima.ki.anyburl.structure.RuleUntyped;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

public abstract class Rule {
    protected static Random rand = new Random();
    protected static boolean APPLICATION_MODE = false;
    protected static final String[] variables = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P"};
    protected static HashMap<String, Integer> variables2Indices = new HashMap();
    protected Atom head;
    protected Body body;
    protected Negation negation = null;
    protected int hashcode = 0;
    protected boolean hashcodeInitialized = false;
    protected int predicted = 0;
    protected int correctlyPredicted = 0;
    protected double confidence = 0.0;
    private double previousConfidence = 0.0;
    protected int nextFreeVariable = 0;

    static {
        int i = 0;
        while (i < variables.length) {
            variables2Indices.put(variables[i], i);
            ++i;
        }
    }

    public Rule(RuleUntyped r) {
        this.body = r.body;
        this.head = r.head;
        this.confidence = r.confidence;
        this.correctlyPredicted = r.correctlyPredicted;
        this.predicted = r.predicted;
        this.negation = r.negation;
    }

    public Rule(Atom head) {
        this.head = head;
        this.body = new Body();
    }

    public Rule() {
        this.body = new Body();
    }

    public Rule getCopy() {
        Rule r;
        RuleUntyped copy = new RuleUntyped(this.head.createCopy());
        for (Atom bodyLiteral : this.body) {
            copy.body.add(bodyLiteral.createCopy());
        }
        copy.nextFreeVariable = this.nextFreeVariable;
        if (copy.isCyclic()) {
            r = new RuleCyclic(copy);
            return r;
        }
        if (copy.isAcyclic1()) {
            r = new RuleAcyclic1(copy);
            return r;
        }
        if (copy.isAcyclic2()) {
            r = new RuleAcyclic2(copy);
            return r;
        }
        return null;
    }

    public boolean hasNegation() {
        return this.negation != null;
    }

    public Atom getNegatedLiteral() {
        if (this.hasNegation()) {
            return this.negation.getAtom();
        }
        return null;
    }

    public static void applicationMode() {
        APPLICATION_MODE = true;
    }

    public void setHead(Atom head) {
        this.head = head;
    }

    public void addBodyAtom(Atom atom) {
        this.body.add(atom);
    }

    public Atom getBodyAtom(int index) {
        return this.body.get(index);
    }

    public Atom getHead() {
        return this.head;
    }

    public String getTargetRelation() {
        return this.head.getRelation();
    }

    public int getPredicted() {
        return this.predicted;
    }

    public int getCorrectlyPredicted() {
        return this.correctlyPredicted;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public int bodysize() {
        return this.body.size();
    }

    public boolean isTrivial() {
        return this.bodysize() == 1 && this.head.equals(this.body.get(0));
    }

    public double getAppliedConfidence() {
        return (double)this.getCorrectlyPredicted() / ((double)this.getPredicted() + (double)Settings.UNSEEN_NEGATIVE_EXAMPLES);
    }

    public boolean isXYRule() {
        return !this.head.isLeftC() && !this.head.isRightC();
    }

    public boolean isXRule() {
        if (this.isXYRule()) {
            return false;
        }
        return !this.head.isLeftC();
    }

    public boolean isYRule() {
        if (this.isXYRule()) {
            return false;
        }
        return !this.head.isRightC();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.predicted) + "\t");
        sb.append(String.valueOf(this.correctlyPredicted) + "\t");
        sb.append(String.valueOf(this.confidence) + "\t");
        sb.append(this.head);
        sb.append(" <= ");
        sb.append(this.body.toString());
        if (this.hasNegation()) {
            sb.append(", ");
            sb.append(this.negation);
        }
        return sb.toString();
    }

    public boolean equals(Object thatObject) {
        if (thatObject instanceof Rule) {
            Rule that = (Rule)thatObject;
            if (this.head.equals(that.head) && this.body.equals(that.body)) {
                if (this.negation == null && that.negation == null) {
                    return true;
                }
                if (this.negation == null && that.negation != null) {
                    return false;
                }
                if (this.negation != null && that.negation == null) {
                    return false;
                }
                return this.negation.equals(that.negation);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        if (!this.hashcodeInitialized) {
            StringBuffer sb = new StringBuffer(this.head.toString());
            for (Atom atom : this.body) {
                sb.append(atom.getRelation());
            }
            if (this.negation != null) {
                sb.append(this.negation);
            }
            this.hashcode = sb.toString().hashCode();
            this.hashcodeInitialized = true;
        }
        return this.hashcode;
    }

    public abstract void computeScores(TripleSet var1);

    public abstract HashSet<String> computeTailResults(String var1, TripleSet var2);

    public abstract HashSet<String> computeHeadResults(String var1, TripleSet var2);

    public abstract boolean isPredictedX(String var1, String var2, Triple var3, TripleSet var4);

    public abstract boolean isRefinable();

    public abstract Triple getRandomValidPrediction(TripleSet var1);

    public abstract Triple getRandomInvalidPrediction(TripleSet var1);

    public abstract ArrayList<Triple> getPredictions(TripleSet var1);

    public abstract boolean isSingleton(TripleSet var1);

    public boolean isMoreSpecific(Rule general) {
        return false;
    }

    public boolean isRedundantACRule(TripleSet triples) {
        return false;
    }

    public TripleSet materialize(TripleSet trainingSet) {
        return null;
    }

    public void setNegation(Atom atom) {
        Atom copy = atom.createCopy();
        if ((atom.getLeft().equals("X") || atom.getLeft().equals("Y")) && atom.getRight().length() <= 1) {
            copy.setRight("Z");
        }
        if ((atom.getRight().equals("X") || atom.getRight().equals("Y")) && atom.getLeft().length() <= 1) {
            copy.setLeft("Z");
        }
        this.negation = new Negation(copy);
    }

    public double getPreviousConfidence() {
        return this.previousConfidence;
    }

    protected boolean checkNegation(TripleSet triples, String variable, String xvalue) {
        if (this.hasNegation()) {
            if (this.negation.getLeft().equals(variable)) {
                Set<String> tails = triples.getTailEntities(this.negation.getRelation(), xvalue);
                if (this.negation.isVariableRight() ? tails.size() > 0 : tails.contains(this.negation.getRight())) {
                    return false;
                }
            } else if (this.negation.getRight().equals(variable)) {
                Set<String> heads = triples.getHeadEntities(this.negation.getRelation(), xvalue);
                if (this.negation.isVariableLeft() ? heads.size() > 0 : heads.contains(this.negation.getLeft())) {
                    return false;
                }
            }
        }
        return true;
    }
}

