/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.structure.Atom;
import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.structure.RuleAcyclic;
import de.unima.ki.anyburl.structure.RuleAcyclic2;
import de.unima.ki.anyburl.structure.RuleCyclic;
import de.unima.ki.anyburl.structure.RuleUntyped;

public class RuleAcyclic1
extends RuleAcyclic {
    public RuleAcyclic1(RuleUntyped r) {
        super(r);
    }

    @Override
    protected String getUnboundVariable() {
        return null;
    }

    @Override
    public boolean isRedundantACRule(TripleSet triples) {
        Atom last = this.body.getLast();
        return last.isRightC() ? triples.getHeadEntities(last.getRelation(), last.getRight()).size() < Settings.AC_MIN_NUM_OF_LAST_ATOM_GROUNDINGS : triples.getTailEntities(last.getRelation(), last.getLeft()).size() < Settings.AC_MIN_NUM_OF_LAST_ATOM_GROUNDINGS;
    }

    @Override
    public boolean isSingleton(TripleSet triples) {
        if (this.body.get(0).getRight().equals("X") && this.body.get(0).getRight().equals("Y")) {
            String head = this.body.get(0).getLeft();
            String relation = this.body.get(0).getRelation();
            return triples.getTailEntities(relation, head).size() <= 1;
        }
        String tail = this.body.get(0).getRight();
        String relation = this.body.get(0).getRelation();
        return triples.getHeadEntities(relation, tail).size() <= 1;
    }

    @Override
    public boolean isMoreSpecific(Rule general) {
        Rule rg;
        if (general instanceof RuleCyclic && this.isCyclic()) {
            rg = (RuleCyclic)general;
            if (!this.head.getXYGeneralization().equals(((RuleCyclic)rg).head)) {
                return false;
            }
            if (this.bodysize() == rg.bodysize()) {
                if (this.body.get(0).contains("X")) {
                    int i = 0;
                    while (i < this.bodysize() - 1) {
                        if (!this.body.get(i).equals(((RuleCyclic)rg).body.get(i))) {
                            return false;
                        }
                        ++i;
                    }
                    return this.body.get(this.bodysize() - 1).moreSpecial(((RuleCyclic)rg).body.get(this.bodysize() - 1));
                }
                String vSpecific = "Y";
                String vGeneral = "Y";
                int i = 0;
                while (i < this.bodysize() - 1) {
                    Atom gAtom;
                    Atom sAtom = this.body.get(i);
                    if (!sAtom.equals(gAtom = ((RuleCyclic)rg).body.get(this.bodysize() - 1 - i), vSpecific, vGeneral)) {
                        return false;
                    }
                    vSpecific = sAtom.getOtherTerm(vSpecific);
                    vGeneral = gAtom.getOtherTerm(vGeneral);
                    ++i;
                }
                if (this.body.get(this.bodysize() - 1).moreSpecial(((RuleCyclic)rg).body.get(0), vSpecific, vGeneral)) {
                    return true;
                }
            }
        }
        if (general instanceof RuleAcyclic2) {
            rg = (RuleAcyclic2)general;
            if (!this.head.equals(((RuleAcyclic2)rg).head)) {
                return false;
            }
            if (this.bodysize() > rg.bodysize()) {
                return false;
            }
            int i = 0;
            while (i < this.bodysize() - 1) {
                if (!this.body.get(i).equals(((RuleAcyclic2)rg).body.get(i))) {
                    return false;
                }
                ++i;
            }
            if (this.body.get(this.bodysize() - 1).moreSpecial(((RuleAcyclic2)rg).body.get(this.bodysize() - 1))) {
                return true;
            }
        }
        return false;
    }

    public boolean isCyclic() {
        return this.getHead().getConstant().equals(this.body.getLast().getConstant());
    }

    public String toXYString() {
        if (this.head.getLeft().equals("X")) {
            String c = this.head.getRight();
            StringBuffer sb = new StringBuffer();
            sb.append(this.getHead().toString(c, "Y"));
            int i = 0;
            while (i < this.bodysize()) {
                sb.append(this.getBodyAtom(i).toString(c, "Y"));
                ++i;
            }
            String rs = sb.toString();
            return rs;
        }
        if (this.head.getRight().equals("Y")) {
            String c = this.head.getLeft();
            StringBuffer sb = new StringBuffer();
            sb.append(this.getHead().toString(c, "X"));
            int i = this.bodysize() - 1;
            while (i >= 0) {
                sb.append(this.getBodyAtom(i).toString(c, "X"));
                --i;
            }
            String rs = sb.toString();
            return rs;
        }
        System.err.println("toXYString of the following rule not implemented: " + this);
        System.exit(1);
        return null;
    }
}

