/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.structure.Atom;
import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.structure.RuleAcyclic;
import de.unima.ki.anyburl.structure.RuleUntyped;
import java.util.HashMap;

public class RuleAcyclic2
extends RuleAcyclic {
    private String unboundVariable = null;

    public RuleAcyclic2(RuleUntyped r) {
        super(r);
    }

    @Override
    protected String getUnboundVariable() {
        if (this.unboundVariable != null) {
            return this.unboundVariable;
        }
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (Atom atom : this.body) {
            if (!atom.getLeft().equals("X") && !atom.getLeft().equals("Y")) {
                if (counter.containsKey(atom.getLeft())) {
                    counter.put(atom.getLeft(), 2);
                } else {
                    counter.put(atom.getLeft(), 1);
                }
            }
            if (atom.getRight().equals("X") || atom.getRight().equals("Y")) continue;
            if (counter.containsKey(atom.getRight())) {
                counter.put(atom.getRight(), 2);
                continue;
            }
            counter.put(atom.getRight(), 1);
        }
        for (String variable : counter.keySet()) {
            if ((Integer)counter.get(variable) != 1) continue;
            this.unboundVariable = variable;
            return variable;
        }
        return this.unboundVariable;
    }

    @Override
    public boolean isSingleton(TripleSet triples) {
        return false;
    }

    @Override
    public boolean isMoreSpecific(Rule general) {
        if (general instanceof RuleAcyclic2) {
            RuleAcyclic2 rg = (RuleAcyclic2)general;
            if (this.getHead().equals(rg.getHead()) && this.bodysize() <= rg.bodysize()) {
                int i = 0;
                while (i < this.bodysize()) {
                    Atom a = this.getBodyAtom(i);
                    if (!rg.body.contains(a)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isRedundantACRule(TripleSet triples) {
        Atom last = this.body.getLast();
        return last.isRightC() ? triples.getTriplesByRelation(last.getRelation()).size() < Settings.AC_MIN_NUM_OF_LAST_ATOM_GROUNDINGS : triples.getTriplesByRelation(last.getRelation()).size() < Settings.AC_MIN_NUM_OF_LAST_ATOM_GROUNDINGS;
    }
}

