/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.data.SampledPairedResultSet;
import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.exceptions.TimeOutException;
import de.unima.ki.anyburl.exceptions.Timer;
import de.unima.ki.anyburl.structure.Atom;
import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.structure.RuleUntyped;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class RuleCyclic
extends Rule {
    public RuleCyclic(RuleUntyped r) {
        super(r);
        if (this.body.get(0).contains("Y") && this.bodysize() > 1) {
            int i = 0;
            while (i <= this.bodysize() / 2 - 1) {
                int j = this.bodysize() - i - 1;
                Atom atom_i = this.body.get(i);
                Atom atom_j = this.body.get(j);
                this.body.set(i, atom_j);
                this.body.set(j, atom_i);
                ++i;
            }
            this.body.normalizeVariableNames();
        }
    }

    @Override
    public HashSet<String> computeTailResults(String head, TripleSet ts) {
        HashSet<String> results = new HashSet<String>();
        Timer count = new Timer();
        this.getCyclic("X", "Y", head, 0, true, ts, new HashSet<String>(), results, count);
        return results;
    }

    @Override
    public HashSet<String> computeHeadResults(String tail, TripleSet ts) {
        HashSet<String> results = new HashSet<String>();
        Timer count = new Timer();
        this.getCyclic("Y", "X", tail, this.bodysize() - 1, false, ts, new HashSet<String>(), results, count);
        return results;
    }

    @Override
    public void computeScores(TripleSet triples) {
        SampledPairedResultSet xypairsReverse;
        SampledPairedResultSet xypairs;
        if (this.body.get(0).contains("X")) {
            xypairs = this.beamBodyCyclicEDIS("X", "Y", triples);
            xypairsReverse = this.beamBodyCyclicReverseEDIS("X", "Y", triples);
        } else {
            xypairs = this.beamBodyCyclicEDIS("Y", "X", triples);
            xypairsReverse = this.beamBodyCyclicReverseEDIS("Y", "X", triples);
        }
        int predictedAll = 0;
        int correctlyPredictedAll = 0;
        int correctlyPredicted = 0;
        int predicted = 0;
        for (String key : xypairsReverse.getValues().keySet()) {
            for (String value : xypairsReverse.getValues().get(key)) {
                ++predicted;
                if (!triples.isTrue(key, this.head.getRelation(), value)) continue;
                ++correctlyPredicted;
            }
        }
        predictedAll += predicted;
        correctlyPredictedAll += correctlyPredicted;
        correctlyPredicted = 0;
        predicted = 0;
        for (String key : xypairs.getValues().keySet()) {
            for (String value : xypairs.getValues().get(key)) {
                ++predicted;
                if (!triples.isTrue(key, this.head.getRelation(), value)) continue;
                ++correctlyPredicted;
            }
        }
        this.predicted = predictedAll += predicted;
        this.correctlyPredicted = correctlyPredictedAll += correctlyPredicted;
        this.confidence = (double)this.correctlyPredicted / (double)this.predicted;
    }

    @Override
    public Triple getRandomValidPrediction(TripleSet triples) {
        ArrayList<Triple> validPredictions = this.getPredictions(triples, 1);
        if (validPredictions == null || validPredictions.size() == 0) {
            return null;
        }
        if (validPredictions.size() == 0) {
            return null;
        }
        int index = rand.nextInt(validPredictions.size());
        return validPredictions.get(index);
    }

    @Override
    public Triple getRandomInvalidPrediction(TripleSet triples) {
        ArrayList<Triple> validPredictions = this.getPredictions(triples, -1);
        if (validPredictions == null || validPredictions.size() == 0) {
            return null;
        }
        if (validPredictions.size() == 0) {
            return null;
        }
        int index = rand.nextInt(validPredictions.size());
        return validPredictions.get(index);
    }

    @Override
    public ArrayList<Triple> getPredictions(TripleSet triples) {
        return this.getPredictions(triples, 0);
    }

    protected ArrayList<Triple> getPredictions(TripleSet triples, int valid) {
        SampledPairedResultSet xypairs = this.body.get(0).contains("X") ? this.groundBodyCyclic("X", "Y", triples) : this.groundBodyCyclic("Y", "X", triples);
        ArrayList<Triple> predictions = new ArrayList<Triple>();
        for (String key : xypairs.getValues().keySet()) {
            for (String value : xypairs.getValues().get(key)) {
                Triple validPrediction;
                if (valid == 1) {
                    if (!triples.isTrue(key, this.head.getRelation(), value)) continue;
                    validPrediction = new Triple(key, this.head.getRelation(), value);
                    predictions.add(validPrediction);
                    continue;
                }
                if (valid == -1) {
                    if (triples.isTrue(key, this.head.getRelation(), value)) continue;
                    Triple invalidPrediction = new Triple(key, this.head.getRelation(), value);
                    predictions.add(invalidPrediction);
                    continue;
                }
                validPrediction = new Triple(key, this.head.getRelation(), value);
                predictions.add(validPrediction);
            }
        }
        return predictions;
    }

    @Override
    public boolean isPredictedX(String leftValue, String rightValue, Triple forbidden, TripleSet ts) {
        System.err.println("method not YET available for an extended/refinde rule");
        return false;
    }

    private void getCyclic(String currentVariable, String lastVariable, String value, int bodyIndex, boolean direction, TripleSet triples, HashSet<String> previousValues, HashSet<String> finalResults, Timer count) {
        if (this.hasNegation()) {
            if (this.negation.getLeft().equals(currentVariable)) {
                Set<String> tails = triples.getTailEntities(this.negation.getRelation(), value);
                if (this.negation.isVariableRight() ? tails.size() > 0 : tails.contains(this.negation.getRight())) {
                    return;
                }
            } else if (this.negation.getRight().equals(currentVariable)) {
                Set<String> heads = triples.getHeadEntities(this.negation.getRelation(), value);
                if (this.negation.isVariableLeft() ? heads.size() > 0 : heads.contains(this.negation.getLeft())) {
                    return;
                }
            }
        }
        if (Rule.APPLICATION_MODE && finalResults.size() >= Settings.DISCRIMINATION_BOUND) {
            finalResults.clear();
            return;
        }
        Atom atom = this.body.get(bodyIndex);
        boolean headNotTail = atom.getLeft().equals(currentVariable);
        if (previousValues.contains(value)) {
            return;
        }
        if (direction && this.body.size() - 1 == bodyIndex || !direction && bodyIndex == 0) {
            for (String v : triples.getEntities(atom.getRelation(), value, headNotTail)) {
                if (!Rule.APPLICATION_MODE && count.timeOut()) {
                    throw new TimeOutException();
                }
                if (previousValues.contains(v) || value.equals(v)) continue;
                finalResults.add(v);
            }
            return;
        }
        Set<String> results = triples.getEntities(atom.getRelation(), value, headNotTail);
        String nextVariable = headNotTail ? atom.getRight() : atom.getLeft();
        HashSet<String> currentValues = new HashSet<String>();
        currentValues.addAll(previousValues);
        currentValues.add(value);
        int i = 0;
        for (String nextValue : results) {
            if (!Rule.APPLICATION_MODE && count.timeOut()) {
                throw new TimeOutException();
            }
            int updatedBodyIndex = direction ? bodyIndex + 1 : bodyIndex - 1;
            this.getCyclic(nextVariable, lastVariable, nextValue, updatedBodyIndex, direction, triples, currentValues, finalResults, count);
            ++i;
        }
    }

    private SampledPairedResultSet groundBodyCyclic(String firstVariable, String lastVariable, TripleSet triples) {
        return this.groundBodyCyclic(firstVariable, lastVariable, triples, true);
    }

    private SampledPairedResultSet groundBodyCyclic(String firstVariable, String lastVariable, TripleSet triples, boolean samplingOn) {
        SampledPairedResultSet groundings = new SampledPairedResultSet();
        Atom atom = this.body.get(0);
        boolean headNotTail = atom.getLeft().equals(firstVariable);
        ArrayList<Triple> rtriples = triples.getTriplesByRelation(atom.getRelation());
        int counter = 0;
        Timer count = new Timer();
        for (Triple t : rtriples) {
            ++counter;
            HashSet<String> lastVariableGroundings = new HashSet<String>();
            this.getCyclic(firstVariable, lastVariable, t.getValue(headNotTail), 0, true, triples, new HashSet<String>(), lastVariableGroundings, count);
            if (lastVariableGroundings.size() > 0) {
                if (firstVariable.equals("X")) {
                    groundings.addKey(t.getValue(headNotTail));
                    for (String lastVariableValue : lastVariableGroundings) {
                        groundings.addValue(lastVariableValue);
                    }
                } else {
                    for (String lastVariableValue : lastVariableGroundings) {
                        groundings.addKey(lastVariableValue);
                        groundings.addValue(t.getValue(headNotTail));
                    }
                }
            }
            if ((counter > Settings.SAMPLE_SIZE || groundings.size() > Settings.SAMPLE_SIZE) && samplingOn) break;
            if (Rule.APPLICATION_MODE || !count.timeOut()) continue;
            throw new TimeOutException();
        }
        return groundings;
    }

    private SampledPairedResultSet beamBodyCyclic(String firstVariable, String lastVariable, TripleSet triples) {
        Triple t;
        SampledPairedResultSet groundings = new SampledPairedResultSet();
        Atom atom = this.body.get(0);
        boolean headNotTail = atom.getLeft().equals(firstVariable);
        int attempts = 0;
        int repetitions = 0;
        while ((t = triples.getRandomTripleByRelation(atom.getRelation())) != null) {
            ++attempts;
            String lastVarGrounding = this.beamCyclic(firstVariable, t.getValue(headNotTail), 0, true, triples, new HashSet<String>());
            if (lastVarGrounding != null) {
                if (firstVariable.equals("X")) {
                    groundings.addKey(t.getValue(headNotTail));
                    repetitions = groundings.addValue(lastVarGrounding) ? 0 : ++repetitions;
                } else {
                    groundings.addKey(lastVarGrounding);
                    repetitions = groundings.addValue(t.getValue(headNotTail)) ? 0 : ++repetitions;
                }
            }
            if (Settings.BEAM_SAMPLING_MAX_REPETITIONS <= repetitions || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS <= attempts || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS <= groundings.size()) break;
        }
        return groundings;
    }

    private SampledPairedResultSet beamBodyCyclicEDIS(String firstVariable, String lastVariable, TripleSet triples) {
        SampledPairedResultSet groundings = new SampledPairedResultSet();
        Atom atom = this.body.get(0);
        boolean headNotTail = atom.getLeft().equals(firstVariable);
        int repetitions = 0;
        ArrayList<String> entities = triples.getNRandomEntitiesByRelation(atom.getRelation(), headNotTail, Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS);
        for (String e : entities) {
            String lastVarGrounding = this.beamCyclic(firstVariable, e, 0, true, triples, new HashSet<String>());
            if (lastVarGrounding != null) {
                if (firstVariable.equals("X")) {
                    groundings.addKey(e);
                    repetitions = groundings.addValue(lastVarGrounding) ? 0 : ++repetitions;
                } else {
                    groundings.addKey(lastVarGrounding);
                    repetitions = groundings.addValue(e) ? 0 : ++repetitions;
                }
            }
            if (Settings.BEAM_SAMPLING_MAX_REPETITIONS <= repetitions || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS <= groundings.size()) break;
        }
        groundings.setChaoEstimate(repetitions);
        return groundings;
    }

    public int getChaoEstimate(int f1, int f2, int d) {
        return (int)((double)d + (double)(f1 * f1) / (2.0 * (double)f2));
    }

    private SampledPairedResultSet beamBodyCyclicReverse(String firstVariable, String lastVariable, TripleSet triples) {
        Triple t;
        SampledPairedResultSet groundings = new SampledPairedResultSet();
        Atom atom = this.body.getLast();
        boolean headNotTail = atom.getLeft().equals(lastVariable);
        int attempts = 0;
        int repetitions = 0;
        while ((t = triples.getRandomTripleByRelation(atom.getRelation())) != null) {
            ++attempts;
            String firstVarGrounding = this.beamCyclic(lastVariable, t.getValue(headNotTail), this.bodysize() - 1, false, triples, new HashSet<String>());
            if (firstVarGrounding != null) {
                if (firstVariable.equals("X")) {
                    groundings.addKey(firstVarGrounding);
                    repetitions = groundings.addValue(t.getValue(headNotTail)) ? 0 : ++repetitions;
                } else {
                    groundings.addKey(t.getValue(headNotTail));
                    repetitions = groundings.addValue(firstVarGrounding) ? 0 : ++repetitions;
                }
            }
            if (Settings.BEAM_SAMPLING_MAX_REPETITIONS <= repetitions || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS <= attempts || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS <= groundings.size()) break;
        }
        return groundings;
    }

    private SampledPairedResultSet beamBodyCyclicReverseEDIS(String firstVariable, String lastVariable, TripleSet triples) {
        SampledPairedResultSet groundings = new SampledPairedResultSet();
        Atom atom = this.body.getLast();
        boolean headNotTail = atom.getLeft().equals(lastVariable);
        int repetitions = 0;
        ArrayList<String> entities = triples.getNRandomEntitiesByRelation(atom.getRelation(), headNotTail, Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS);
        for (String e : entities) {
            String firstVarGrounding = this.beamCyclic(lastVariable, e, this.bodysize() - 1, false, triples, new HashSet<String>());
            if (firstVarGrounding != null) {
                if (firstVariable.equals("X")) {
                    groundings.addKey(firstVarGrounding);
                    repetitions = groundings.addValue(e) ? 0 : ++repetitions;
                } else {
                    groundings.addKey(e);
                    repetitions = groundings.addValue(firstVarGrounding) ? 0 : ++repetitions;
                }
            }
            if (Settings.BEAM_SAMPLING_MAX_REPETITIONS <= repetitions || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS <= groundings.size()) break;
        }
        return groundings;
    }

    private HashSet<String> beamPGBodyCyclic(String firstVariable, String lastVariable, String value, int bodyIndex, boolean direction, TripleSet triples) {
        HashSet<String> groundings = new HashSet<String>();
        Atom atom = this.body.get(bodyIndex);
        boolean headNotTail = atom.getLeft().equals(firstVariable);
        int attempts = 0;
        int repetitions = 0;
        boolean startFine = !triples.getEntities(atom.getRelation(), value, headNotTail).isEmpty();
        while (startFine) {
            ++attempts;
            String grounding = this.beamCyclic(firstVariable, value, bodyIndex, direction, triples, new HashSet<String>());
            if (grounding != null) {
                repetitions = groundings.add(grounding) ? 0 : ++repetitions;
            }
            if (Settings.BEAM_SAMPLING_MAX_REPETITIONS <= repetitions || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDING_ATTEMPTS <= attempts || Settings.BEAM_SAMPLING_MAX_BODY_GROUNDINGS <= groundings.size()) break;
        }
        return groundings;
    }

    protected String beamCyclic(String currentVariable, String value, int bodyIndex, boolean direction, TripleSet triples, HashSet<String> previousValues) {
        if (value == null) {
            return null;
        }
        Atom atom = this.body.get(bodyIndex);
        boolean headNotTail = atom.getLeft().equals(currentVariable);
        if (previousValues.contains(value)) {
            return null;
        }
        if (direction && this.body.size() - 1 == bodyIndex || !direction && bodyIndex == 0) {
            String finalValue = triples.getRandomEntity(atom.getRelation(), value, headNotTail);
            if (previousValues.contains(finalValue)) {
                return null;
            }
            if (value.equals(finalValue)) {
                return null;
            }
            return finalValue;
        }
        String nextValue = triples.getRandomEntity(atom.getRelation(), value, headNotTail);
        String nextVariable = headNotTail ? atom.getRight() : atom.getLeft();
        previousValues.add(value);
        int updatedBodyIndex = direction ? bodyIndex + 1 : bodyIndex - 1;
        return this.beamCyclic(nextVariable, nextValue, updatedBodyIndex, direction, triples, previousValues);
    }

    @Override
    public boolean isRefinable() {
        return true;
    }

    @Override
    public boolean isSingleton(TripleSet triples) {
        return false;
    }
}

