/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.structure;

import de.unima.ki.anyburl.data.Triple;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.structure.Atom;
import de.unima.ki.anyburl.structure.Body;
import de.unima.ki.anyburl.structure.Rule;
import java.util.ArrayList;
import java.util.HashSet;

public class RuleUntyped
extends Rule {
    public RuleUntyped(Atom head) {
        this.head = head;
        this.body = new Body();
    }

    public RuleUntyped() {
        this.body = new Body();
    }

    public boolean isCyclic() {
        if (this.head == null) {
            return false;
        }
        return !this.head.isLeftC() && !this.head.isRightC();
    }

    public boolean isAcyclic1() {
        if (this.isCyclic()) {
            return false;
        }
        return this.body.get(this.bodysize() - 1).isLeftC() || this.body.get(this.bodysize() - 1).isRightC();
    }

    public boolean isAcyclic2() {
        if (this.isCyclic()) {
            return false;
        }
        return !this.body.get(this.bodysize() - 1).isLeftC() && !this.body.get(this.bodysize() - 1).isRightC();
    }

    public RuleUntyped(int predicted, int correctlyPredicted, double confidence) {
        this.predicted = predicted;
        this.correctlyPredicted = correctlyPredicted;
        this.confidence = confidence;
        this.body = new Body();
    }

    protected RuleUntyped getLeftRightGeneralization() {
        RuleUntyped lrG = this.createCopy();
        String leftConstant = lrG.head.getLeft();
        int xcount = lrG.replaceByVariable(leftConstant, "X");
        String rightConstant = lrG.head.getRight();
        int ycount = lrG.replaceByVariable(rightConstant, "Y");
        if (xcount < 2 || ycount < 2) {
            lrG = null;
        }
        return lrG;
    }

    protected RuleUntyped getLeftGeneralization() {
        String leftConstant;
        RuleUntyped leftG = this.createCopy();
        int xcount = leftG.replaceByVariable(leftConstant = leftG.head.getLeft(), "X");
        if (xcount < 2) {
            leftG = null;
        }
        return leftG;
    }

    protected RuleUntyped getRightGeneralization() {
        String rightConstant;
        RuleUntyped rightG = this.createCopy();
        int ycount = rightG.replaceByVariable(rightConstant = rightG.head.getRight(), "Y");
        if (ycount < 2) {
            rightG = null;
        }
        return rightG;
    }

    protected RuleUntyped createCopy() {
        RuleUntyped copy = new RuleUntyped(this.head.createCopy());
        for (Atom bodyLiteral : this.body) {
            copy.body.add(bodyLiteral.createCopy());
        }
        copy.nextFreeVariable = this.nextFreeVariable;
        return copy;
    }

    protected int replaceByVariable(String constant, String variable) {
        int count = this.head.replaceByVariable(constant, variable);
        for (Atom batom : this.body) {
            int bcount = batom.replaceByVariable(constant, variable);
            count += bcount;
        }
        return count;
    }

    protected void replaceNearlyAllConstantsByVariables() {
        int counter = 0;
        for (Atom atom : this.body) {
            String c;
            if (++counter == this.body.size()) break;
            if (atom.isLeftC()) {
                c = atom.getLeft();
                this.replaceByVariable(c, Rule.variables[this.nextFreeVariable]);
                ++this.nextFreeVariable;
            }
            if (!atom.isRightC()) continue;
            c = atom.getRight();
            this.replaceByVariable(c, Rule.variables[this.nextFreeVariable]);
            ++this.nextFreeVariable;
        }
    }

    protected void replaceAllConstantsByVariables() {
        for (Atom atom : this.body) {
            String c;
            if (atom.isLeftC()) {
                c = atom.getLeft();
                this.replaceByVariable(c, Rule.variables[this.nextFreeVariable]);
                ++this.nextFreeVariable;
            }
            if (!atom.isRightC()) continue;
            c = atom.getRight();
            this.replaceByVariable(c, Rule.variables[this.nextFreeVariable]);
            ++this.nextFreeVariable;
        }
    }

    @Override
    public HashSet<String> computeTailResults(String head, TripleSet ts) {
        System.err.println("method not available for an untyped rule");
        return null;
    }

    @Override
    public HashSet<String> computeHeadResults(String tail, TripleSet ts) {
        System.err.println("method not available for an untyped rule");
        return null;
    }

    @Override
    public void computeScores(TripleSet ts) {
        System.err.println("method not available for an untyped rule");
    }

    @Override
    public boolean isPredictedX(String leftValue, String rightValue, Triple forbidden, TripleSet ts) {
        System.err.println("method not available for an untyped rule");
        return false;
    }

    @Override
    public boolean isRefinable() {
        return false;
    }

    @Override
    public Triple getRandomValidPrediction(TripleSet ts) {
        System.err.println("method not available for an untyped rule");
        return null;
    }

    @Override
    public Triple getRandomInvalidPrediction(TripleSet ts) {
        System.err.println("method not available for an untyped rule");
        return null;
    }

    @Override
    public ArrayList<Triple> getPredictions(TripleSet ts) {
        System.err.println("method not available for an untyped rule");
        return null;
    }

    @Override
    public boolean isSingleton(TripleSet triples) {
        return false;
    }
}

