/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.threads;

import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.structure.RuleCyclic;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;

public class RuleWriterAsThread
extends Thread {
    private LinkedList<Rule> rules = new LinkedList();
    private String filepath;
    private int elapsedSeconds;
    private PrintWriter log;
    private int snapshotCounter;

    public RuleWriterAsThread(String filepath, int snapshotCounter, HashSet<Rule>[] rules307, PrintWriter log, int elapsedSeconds) {
        int i = 0;
        while (i < 307) {
            HashSet<Rule> ruleSet = rules307[i];
            for (Rule r : ruleSet) {
                this.rules.add(r);
            }
            ++i;
        }
        this.filepath = filepath;
        this.elapsedSeconds = elapsedSeconds;
        this.log = log;
        this.snapshotCounter = snapshotCounter;
    }

    public RuleWriterAsThread(String filepath, int snapshotCounter, ArrayList<HashSet<Rule>> ruless, PrintWriter log, int elapsedSeconds) {
        for (HashSet<Rule> ruleSet : ruless) {
            for (Rule r : ruleSet) {
                this.rules.add(r);
            }
        }
        this.filepath = filepath;
        this.elapsedSeconds = elapsedSeconds;
        this.log = log;
        this.snapshotCounter = snapshotCounter;
    }

    @Override
    public void run() {
        this.storeRules();
    }

    private void storeRules() {
        long startWriting = System.currentTimeMillis();
        File ruleFile = new File(String.valueOf(this.filepath) + "-" + this.snapshotCounter);
        int maxBodySize = 10;
        int[] acyclicCounter = new int[maxBodySize];
        int[] cyclicCounter = new int[maxBodySize];
        try {
            if (this.log != null) {
                this.log.println();
            }
            if (this.log != null) {
                this.log.println("rule file: " + ruleFile.getPath());
            }
            System.out.println(">>> storing rules in file " + ruleFile.getPath());
            PrintWriter pw = new PrintWriter(ruleFile);
            long numOfRules = 0L;
            for (Rule r : this.rules) {
                if (r.bodysize() < maxBodySize) {
                    if (r instanceof RuleCyclic) {
                        int n = r.bodysize() - 1;
                        cyclicCounter[n] = cyclicCounter[n] + 1;
                    } else {
                        int n = r.bodysize() - 1;
                        acyclicCounter[n] = acyclicCounter[n] + 1;
                    }
                }
                pw.println(r);
                ++numOfRules;
            }
            pw.flush();
            pw.close();
            if (this.log != null) {
                this.log.print("cyclic: ");
            }
            int i = 0;
            while (i < maxBodySize) {
                if (cyclicCounter[i] == 0) break;
                if (this.log != null) {
                    this.log.print(String.valueOf(cyclicCounter[i]) + " | ");
                }
                ++i;
            }
            if (this.log != null) {
                this.log.print("\nacyclic: ");
            }
            i = 0;
            while (i < maxBodySize) {
                if (acyclicCounter[i] == 0) break;
                if (this.log != null) {
                    this.log.print(String.valueOf(acyclicCounter[i]) + " | ");
                }
                ++i;
            }
            long stopWriting = System.currentTimeMillis();
            if (this.log != null) {
                this.log.println("time planned: " + this.snapshotCounter + "s");
            }
            if (this.log != null) {
                this.log.println("time elapsed: " + this.elapsedSeconds + "s");
            }
            System.out.println(">>> stored " + numOfRules + " rules in " + (stopWriting - startWriting) + "ms");
            if (this.log != null) {
                this.log.println("");
            }
            if (this.log != null) {
                this.log.flush();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

