/*
 * Decompiled with CFR 0.152.
 */
package de.unima.ki.anyburl.threads;

import de.unima.ki.anyburl.LearnReinforced;
import de.unima.ki.anyburl.Settings;
import de.unima.ki.anyburl.algorithm.PathSampler;
import de.unima.ki.anyburl.data.TripleSet;
import de.unima.ki.anyburl.exceptions.TimeOutException;
import de.unima.ki.anyburl.structure.Path;
import de.unima.ki.anyburl.structure.Rule;
import de.unima.ki.anyburl.structure.RuleFactory;
import java.util.ArrayList;

public class ScorerReinforced
extends Thread {
    private TripleSet triples;
    private PathSampler sampler;
    private int createdRules = 0;
    private int storedRules = 0;
    private double producedScore = 0.0;
    private int id = 0;
    private boolean mineParamCyclic = true;
    private int mineParamLength = 1;
    private boolean ready = false;
    private boolean onlyXY = false;

    public ScorerReinforced(TripleSet triples, int id) {
        this.triples = triples;
        this.sampler = new PathSampler(triples);
        this.id = id;
    }

    public void setSearchParameters(boolean cyclic, int len) {
        this.mineParamCyclic = cyclic;
        this.mineParamLength = len;
        this.ready = true;
        this.onlyXY = false;
        if (this.mineParamCyclic && this.mineParamLength > Settings.MAX_LENGTH_GROUNDED_CYCLIC) {
            this.onlyXY = true;
        }
    }

    @Override
    public void run() {
        while (!LearnReinforced.areAllThere()) {
            LearnReinforced.heyYouImHere(this.id);
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        System.out.println("THREAD-" + this.id + " starts to work with L=" + this.mineParamLength + " C=" + this.mineParamCyclic + " ");
        boolean done = false;
        while (!done) {
            ArrayList<Rule> learnedRules;
            Path path;
            if (!LearnReinforced.active(this.id, this.storedRules, this.createdRules, this.producedScore, this.mineParamCyclic, this.mineParamLength) || !this.ready) {
                this.createdRules = 0;
                this.storedRules = 0;
                this.producedScore = 0.0;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (this.mineParamCyclic && (path = this.sampler.samplePath(this.mineParamLength + 1, true)) != null && path.isValid()) {
                learnedRules = RuleFactory.getGeneralizations(path, this.onlyXY);
                if (!LearnReinforced.active) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                } else {
                    for (Rule learnedRule : learnedRules) {
                        ++this.createdRules;
                        if (learnedRule.isTrivial() || learnedRule.isRedundantACRule(this.triples) || !LearnReinforced.isStored(learnedRule)) continue;
                        learnedRule.computeScores(this.triples);
                        if (!(learnedRule.getConfidence() >= Settings.THRESHOLD_CONFIDENCE) || learnedRule.getCorrectlyPredicted() < Settings.THRESHOLD_CORRECT_PREDICTIONS || !LearnReinforced.active) continue;
                        LearnReinforced.storeRule(learnedRule);
                        this.producedScore += this.getScoringGain(learnedRule, learnedRule.getCorrectlyPredicted(), learnedRule.getConfidence(), learnedRule.getAppliedConfidence());
                        ++this.storedRules;
                    }
                }
            }
            if (this.mineParamCyclic || (path = this.sampler.samplePath(this.mineParamLength + 1, false)) == null || !path.isValid()) continue;
            learnedRules = RuleFactory.getGeneralizations(path, false);
            if (!LearnReinforced.active) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            for (Rule learnedRule : learnedRules) {
                ++this.createdRules;
                if (learnedRule.isTrivial() || !LearnReinforced.isStored(learnedRule)) continue;
                try {
                    learnedRule.computeScores(this.triples);
                }
                catch (TimeOutException e) {
                    continue;
                }
                if (!(learnedRule.getConfidence() >= Settings.THRESHOLD_CONFIDENCE) || learnedRule.getCorrectlyPredicted() < Settings.THRESHOLD_CORRECT_PREDICTIONS || !LearnReinforced.active) continue;
                LearnReinforced.storeRule(learnedRule);
                this.producedScore += this.getScoringGain(learnedRule, learnedRule.getCorrectlyPredicted(), learnedRule.getConfidence(), learnedRule.getAppliedConfidence());
                ++this.storedRules;
            }
        }
    }

    public double getScoringGain(Rule rule, int correctlyPredicted, double confidence, double appliedConfidence) {
        if (Settings.REWARD == 1) {
            return correctlyPredicted;
        }
        if (Settings.REWARD == 2) {
            return (double)correctlyPredicted * confidence;
        }
        if (Settings.REWARD == 3) {
            return (double)correctlyPredicted * appliedConfidence;
        }
        if (Settings.REWARD == 4) {
            return (double)correctlyPredicted * appliedConfidence * appliedConfidence;
        }
        if (Settings.REWARD == 5) {
            return (double)correctlyPredicted * appliedConfidence / Math.pow(2.0, rule.bodysize() - 1);
        }
        return 0.0;
    }
}

