# ERACS-based CIFAR-10 Training

This repository provides the implementation for reproducing the experiments described in our paper using the CIFAR-10 dataset and the ERACS framework.

## 📦 Installation

Install the required dependencies with:

```bash
pip install -r requirements/requirements.txt
```

We recommend using a virtual environment (e.g., `venv` or `conda`) to avoid conflicts with system packages.

## 🚀 Reproducing Results

Once the dependencies are installed, you can run the following command to reproduce the main experimental results from the paper:

```bash
python train_cifar10.py
```

This will automatically handle dataset loading, training, and evaluation using the specified subset selection strategy.

## 📁 Project Structure

- `train_cifar10.py` — Main training script for CIFAR-10.
- `requirements/requirements.txt` — List of required Python packages.
- `eracs/` — Contains ERACS framework utilities, models, and data loaders.

## 📝 Notes

- The default configuration replicates the results reported in the paper.
- You may modify dataset paths, model parameters, or coreset selection strategies directly in the script or configuration files.