### Nonlinear Reconstruction for Operator Learning of PDEs with Discontinuities
This repository is the official implementation of the paper **Nonlinear Reconstruction for Operator Learning of PDEs**

#### Requirements
The code is based on python 3 (version 3.7) and the packages required can be installed with
```
python3 -m pip install -r requirements.txt
```
#### Source Data
We cover instances of the Linear Advection equation, Burgers' equation and Compressible Euler equations.
Data can be downloaded from https://zenodo.org/record/7115826 (13GB).
Alternatively, run the script `download_data.py` which downloads all required data into the appropriate folder (it requires 'wget' to be installed on your system).
```
python3 download_data.py
```

#### Models Training
Each of the model described in tha peper can be trained by running the corresponding python script `Train*.py`.
The benchmark problem can be specified with the variable `which_example`.
One among `advection`, `burgers`, `shocktube` and `riemann` can be selected, e.g `which_example="advection"`.
The models' hyperparameter can be specified in the corresponding python scripts as well.

 - ResNet: `python3 TrainFNN.py`
 - Fully Convolutional Neural Network: `python3 TrainConv.py`
 - DeepONet: `python3 TrainDON.py` and `python3 TrainDON2D.py` (for the 2d Riemann problem)
 - ShiftDeepONet: `python3 TrainSDON.py` or `python3 TrainSDON2D.py` (for the 2d Riemann problem)
 - Fourier Neural Operator: `python3 TrainFNO.py`

*Remark*: to run the 2D Riemann problem for DON and SDON, run the scripts `TrainDON2D.py` and `TrainSDON2D.py`.
An error will be thrown if the variable `which_example="riemann"` in  `TrainDON.py` and `TrainSDON.py`.

#### Hyperparameters Grid Search
Cross validation for each model can be run with:

 - ResNet: ```python3 ModelSelectionFNN.py```
 - Fully Convolutional Neural Network: ```python3 ModelSelectionConv.py```
 - DeepONet and ShiftDeepONet: ```python3 ModelSelectionDON.py``` and ```python3 ModelSelectionSDON.py```
 - Fourier Neural Operator: ```python3 ModelSelectionFNO.py```

with the variable `retrainings=False`.
The hyperparameters of the models in the Table 1 have been obtained in this way.

The best performing configuration can be obtained by running the script `GetBest.py`, 
and inserting the appropriate folder name in `base_path_list`.
#### Pretrained Models
The models trained and used to compute the errors in Table 1 can be downloaded (600MB) by running:
```
python3 download_models.py
```
*Remark*: the compressed folder has to be unzipped!

#### Error Computations
The errors of the best performing models (Table 1) can be computed by running the Jupyter notebooks `Plot*.ipynb`.
For the 1D problems, set `which_example="advection"` for the linear advection equation, `which_example="burgers"` for the Burgers' equation,
and `which_example="shocktube"` for the shocktube problem.
For the 2D Riemann problem, a different notebook `Plot*2D.ipynb` has to be run.

The trained model for the results in Table 10 are stored in the folder TrainedModels/LinearAdvectionModes. The FNO model error can be computed as described before,
by running the Jupyter notebooks `Plot*.ipynb` and setting `which_example="advection"` and
`folder== "TrainedModels/LinearAdvectionModes/Modes1"` or
`folder== "TrainedModels/LinearAdvectionModes/Modes2"` or 
`folder== "TrainedModels/LinearAdvectionModes/Modes4"`or
`folder== "TrainedModels/LinearAdvectionModes/Modes8"`.

