import os

print("This script will download all files required for benchmark problems."
      " You must have 'wget' installed for the downloads to work.")

folder_name = "data_benchmarks"
if not os.path.isdir(folder_name):
    os.mkdir(folder_name)

fnames = ["LinearAdvection.h5",
          "BurgersEquation006_01b.h5",
          "LaxSodShockTube.h5",
          "0_Riemann30LR.h5",
          "1_Riemann30LR.h5",
          "2_Riemann30LR.h5",
          "3_Riemann30LR.h5"
          ]
for fid, fname in enumerate(fnames):
    print('Downloading file {fname} ({fid+1}/{len(fnames)}):')
    url = "https://zenodo.org/record/7118642/files/" + fname
    cmd = f"wget --directory-prefix {folder_name} {url}"
    os.system(cmd)
