import os
import warnings

import numpy as np
import pandas as pd

warnings.filterwarnings('ignore')

np.random.seed(42)

base_path_list = ["ModelSelectionRiemannFNO"]

for base_path in base_path_list:
    print("#################################################")
    print(base_path)

    b = False
    directories_model = [d for d in os.listdir(base_path) if os.path.isdir(os.path.join(base_path, d))]
    sensitivity_df = pd.DataFrame()
    # print(sensitivity_df)
    selection_criterion = "Best Testing Error"  # metric_3b
    eval_metric = "Best Testing Error"
    threshold = 0.005
    mode = "min"

    L2_norm = []
    criterion = []
    best_retrain_list = []
    list_models_setup = list()

    for subdirec in directories_model:
        try:
            model_path = base_path

            sample_path = model_path + "/" + subdirec
            errors = pd.read_csv(sample_path + "/errors.txt", header=None, sep=":", index_col=0)
            errors = errors.transpose().reset_index().drop("index", 1)
            errors["Setup"] = subdirec

            if errors['Training Error'].values[0] == " nan":
                print("found Nan")
            else:
                sensitivity_df = sensitivity_df.append(errors, ignore_index=True)


        except pd.errors.EmptyDataError:
            print("file Not found")
        except  FileNotFoundError:
            print("file Not found")

    sensitivity_df = sensitivity_df.sort_values(selection_criterion)
    print(sensitivity_df)
    if mode == "min":
        best_setup = sensitivity_df.iloc[0]
    elif mode == "max":
        best_setup = sensitivity_df.iloc[-1]
    else:
        raise ValueError()
    # print(sensitivity_df)
    print("Best Setup:")
    print(best_setup)
