import torch
import time

def measure_tflops(device, size):
    dtype = torch.float16  # Change to float16
    try:
        a = torch.rand(size, size, device=device, dtype=dtype)
        b = torch.rand(size, size, device=device, dtype=dtype)
    except RuntimeError as e:
        print(f"Error creating matrices of size {size}x{size} on {device}: {e}")
        return None

    num_operations = 2 * (size ** 3)

    # Warm up the GPU
    try:
        for _ in range(3):  # Fewer warm-ups for very large matrices to save time
            _ = torch.matmul(a, b)
        torch.cuda.synchronize(device)  # Synchronize after warm-up

        start_time = time.time()
        c = torch.matmul(a, b)
        torch.cuda.synchronize(device)
        end_time = time.time()
        
        time_taken = end_time - start_time
        tflops = (num_operations / time_taken) / 1e12
        return tflops
    except RuntimeError as e:
        print(f"Error during computation: {e}")
        return None

if __name__ == "__main__":
    device = torch.device("cuda:0" if torch.cuda.is_available() else "cpu")
    if device.type == 'cuda':
        for size in [1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 1024, 2048, 4096, 8192, 10240, 12288, 16384]:  # Testing increasingly larger sizes
            tflops = measure_tflops(device, size)
            if tflops is not None:
                print(f"Matrix size {size}x{size}, Estimated TFLOPS: {tflops:.2f}")
            else:
                print(f"Failed to compute TFLOPS for matrix size {size}x{size}.")
    else:
        print("CUDA is not available. Please run this on a machine with a GPU.")

