import sys
sys.path.insert(0, ROOT_PATH)
import comnivore.const as const
from datasets import load_dataset
import numpy as np
def get_gender_meta():
    # dataset = load_dataset("md_gender_bias", "gendered_words", split='train')
    # meta_all = []
    # for i in range(len(dataset)):
    #     word_masculine = dataset[i]['word_masculine'].replace('_', ' ')
    #     word_feminine = dataset[i]['word_feminine'].replace('_', ' ')
    #     meta_all.append([word_feminine, word_masculine])
    dataset = load_dataset("md_gender_bias", "funpedia", split='train')
    persona = np.array([obj['persona'].lower() for obj in dataset])
    p_unique = np.unique(persona)
    meta_all = []
    for i in range(len(p_unique)):
        p = p_unique[i]
        meta_all.append([p, f'not {p}'])
    return meta_all

text_prompts = {
    const.CIVILCOMMENTS_NAME: {
        'labels_text': ['male', 'female', 'LGBTQ', 'christian', 'muslim', 'other religions', 'black', 'white'],
        'labels': ['non-toxic', 'toxic'],
        'labels_bart': ['non-toxic', 'toxic']
    },
    const.HATEXPLAIN_NAME: {
        'labels_text': ['hindu','islam','minority','refugee','indian','caucasian','hispanic','women','disability','homosexual','arab','christian','jewish','men','african','nonreligious','asian','indigenous','heterosexual','buddhism','bisexual','asexual'],
        'labels_openai': ['normal', 'toxic'],
        'labels_hf_sim': ['normal', 'offensive'],
        'labels_bart':  ['normal', 'offensive']
    },
    const.AMAZON_NAME: {
        'labels_text': ['bad'],
        'metas_text': [['discount', 'expensive'], ['free', 'pricey'], ['long', 'short'], ['wordy', 'verbose']],
        'labels': ['negative', 'positive'],
        'labels_bart': ['negative', 'positive']
    }, 
    const.GENDER_BIAS_NAME: {
        'labels_text': ['none'],
        'metas_text':[['strong', 'graceful'], ['assertive', 'delicate'], ['bold', 'elegant'], ['muscular', 'soft'], ['robust', 'gentle'], ['vigorous', 'dainty'], ['powerful', 'domestic'], ['competent', 'incompetent'], ['smart', 'stupid']],
        'labels':  ['female', 'male'],
        'labels_bart':  ['female', 'male'],
    }
}