import numpy as np


def generate_random_grid(size: int, colors: int) -> np.ndarray:
    """Generate a random grid of given size with specified number of colors."""
    return np.random.randint(0, colors, (size, size))


def apply_transformation(grid: np.ndarray, transformation) -> np.ndarray:
    """Apply a transformation function to the input grid and ensure output size consistency."""

    # Convert numpy array to tuple of tuples for compatibility with DSL
    tuple_grid = tuple(tuple(row) for row in grid)
    result = transformation(tuple_grid)

    # Convert result back to numpy array
    output_grid = np.array(result)

    return output_grid


def pad_grid(grid: np.ndarray, target_shape: tuple) -> np.ndarray:
    """Pad the grid to the target shape with zeros."""

    return np.pad(grid, ((0, target_shape[0] - grid.shape[0]), (0, target_shape[1] - grid.shape[1])))
