#!/bin/bash

model=vgg
defense=adv_hvi
data=tiny-imagenet
root=./datasets
n_ensemble=50
step=10
attack=pgd
max_norm=0.03
batch_size=128
echo "Loading" ./checkpoint/${data}_${model}_${max_norm}_${defense}.pth

CUDA_VISIBLE_DEVICES=0 python3 acc_under_attack.py \
    --model $model \
    --defense $defense \
    --data $data \
    --root $root \
    --n_ensemble $n_ensemble \
    --step $step \
    --max_norm $max_norm \
    --attack $attack \
    --batch_size $batch_size

