'''VGG11/13/16/19 in Pytorch.'''
import torch
import torch.nn as nn
from .layers.batchnorm2d import RandHierBatchNorm2d
from .layers.conv2d import RandHierConv2d
from .layers.hierarchical_linear import RandHierarchicalLinear

cfg = {
    'VGG16': [64, 64, 'M', 128, 128, 'M', 256, 256, 256, 'M', 512, 512, 512, 'M', 512, 512, 512, 'M'],
}


class VGG(nn.Module):
    def __init__(self, sigma_0, N, init_s, vgg_name, nclass, img_width=32):
        super(VGG, self).__init__()
        self.sigma_0 = sigma_0
        self.N = N
        self.init_s = init_s
        self.img_width = img_width
        self.classifier = RandHierarchicalLinear(sigma_0, N, init_s, 512, nclass)
        self.features = self._make_layers(cfg[vgg_name])

    def forward(self, x):
        kl_sum = 0
        out = x
        for l in self.features:
            if type(l).__name__.startswith("Rand"):
                out, kl = l.forward(out)
                if kl is not None:
                    kl_sum += kl
            else:
                out = l.forward(out)
        out = out.view(out.size(0), -1)
        out, kl = self.classifier.forward(out)
        kl_sum += kl
        return out, kl_sum





    def _make_layers(self, cfg):
        layers = []
        in_channels = 3
        width = self.img_width
        for x in cfg:
            if x == 'M':
                layers += [nn.MaxPool2d(kernel_size=2, stride=2)]
                width = width // 2
            else:
                layers += [
                        RandHierConv2d(self.sigma_0, self.N, self.init_s, in_channels, x, kernel_size=3, padding=1),
                        RandHierBatchNorm2d(self.sigma_0, self.N, self.init_s, x),
                        nn.ReLU(inplace=True)]
                in_channels = x
        layers += [nn.AvgPool2d(kernel_size=width, stride=1)]
        return nn.Sequential(*layers)

