import json
import argparse
from pathlib import Path

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Copy dataset for new model evaluation")
    # IO
    parser.add_argument("--input_dir", type=str)
    parser.add_argument("--output_dir", type=str)

    args = parser.parse_args()

    input_dir = Path(args.input_dir)
    output_dir = Path(args.output_dir)
    output_dir.mkdir(exist_ok=True, parents=True)

    for file in input_dir.iterdir():
        with open(output_dir.joinpath(file.name), 'w') as f:
            with open(file, 'r') as g:
                try:
                    data = json.load(g)
                    for instance in data['request_states']:
                        if instance["request"]["result"].get('success', False):
                            instance["request"]["result"]['success'] = False
                    json.dump(data, f, indent=4)
                except:
                    print('The input folder should only contain json file.')