import os
import json
import argparse

def merge_results(input_folder, output_file):
    files = os.listdir(input_folder)
    with open(os.path.join(input_folder, output_file), "w") as f:
        for file in files:
            lines = open(os.path.join(input_folder, file)).readlines()
            f.writelines(lines)


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="Query OpenAI")
    # I/O
    parser.add_argument("--input_dir", type=str, default="")
    parser.add_argument("--output_file", type=str, default="")

    args = parser.parse_args()

    merge_results(args.input_dir, args.output_file)
