import argparse
import json
import numpy as np
import re


parser = argparse.ArgumentParser(description="Query OpenAI")
parser.add_argument("--output_file", type=str, default='../../results/causaltimebank/results.jsonl')
args = parser.parse_args()


num_ans, num_out, num_cor = 0, 0, 0
with open(args.output_file) as file:
    lines = file.readlines()

for line in lines:
    try:
        result = json.loads(line)
    except:
        continue
    label = result['instance']['references'][0]['output']['text']
    # output = result['request']['result']['completions'][0]['text']
    # output = result['request']['result']['choices'][0]['text']
    output = result['request']['result']['choices'][0]['message']['content']
    if label != 'no':
        num_ans += 1
    try:
        search_obj = re.search(r'[aA]nswer(.*?): \[(.*)\]', output)
        out_label = re.findall(r'([a-zA-Z-]+)', search_obj.group(2))
        la = out_label.lower()
        if la == 'yes':
            num_out += 1
            if label == 'yes':
                num_cor += 1
    except:
        pass

num_ans = np.array(num_ans)
num_out = np.array(num_out)
num_cor = np.array(num_cor)
p = num_cor / num_out
r = num_cor / num_ans
f1 = 2 * p * r / (p + r)
print('            Cause')
print(f'precision:  {p:.4f}')
print(f'recall:     {r:.4f}')
print(f'f1-score:   {f1:.4f}')