import argparse
import json
import numpy as np
import re


parser = argparse.ArgumentParser(description="Query OpenAI")
parser.add_argument("--output_file", type=str, default='../../results/matres/results.jsonl')
args = parser.parse_args()


num_ans, num_out, num_cor = [0, 0, 0, 0], [0, 0, 0, 0], [0, 0, 0, 0]
with open(args.output_file) as file:
    lines = file.readlines()
rel_class = {'before': 0, 'after': 1, 'equal': 2, 'vague': 3}

for line in lines:
    try:
        result = json.loads(line)
    except:
        continue
    label = result['instance']['references'][0]['output']['text']
    # output = result['request']['result']['completions'][0]['text']
    # output = result['request']['result']['choices'][0]['text']
    output = result['request']['result']['choices'][0]['message']['content']
    if label != 'none':
        num_ans[rel_class[label]] += 1
    try:
        search_obj = re.search(r'[aA]nswer(.*?): \[(.*)\]', output)
        out_label = re.findall(r'([a-zA-Z-]+)', search_obj.group(2))
        la = out_label.lower()
        if la in rel_class.keys():
            num_out[rel_class[la]] += 1
            if la in label:
                num_cor[rel_class[la]] += 1
    except:
        pass

num_ans.append(np.sum(num_ans))
num_out.append(np.sum(num_out))
num_cor.append(np.sum(num_cor))
num_ans = np.array(num_ans)
num_out = np.array(num_out)
num_cor = np.array(num_cor)
p = num_cor / num_out
r = num_cor / num_ans
f1 = 2 * p * r / (p + r)
print('            Before | After | Equal | Vague | Total')
print(f'precision:  {p[0]:.4f} | {p[1]:.4f}| {p[2]:.4f}| {p[3]:.4f}| {p[4]:.4f}')
print(f'recall:     {r[0]:.4f} | {r[1]:.4f}| {r[2]:.4f}| {r[3]:.4f}| {r[4]:.4f}')
print(f'f1-score:   {f1[0]:.4f} | {f1[1]:.4f}| {f1[2]:.4f}| {f1[3]:.4f}| {f1[4]:.4f}')