# ~/bin/bash
LEARNING_RATE=0.1
NET="resnet50_manifoldMixup"
EPOCH=200
GPU_ID=2
BATCH_SIZE=128
DATASET="coarse_cifar100"
TRANSFER_DATASET="cifar100"
SEED_NUM=(1)
for (( i=0; i<${#SEED_NUM[@]}; i++ ))
do
	TAG="seed${SEED_NUM[$i]}_${DATASET}_${NET}_lr${LEARNING_RATE}_bs${BATCH_SIZE}_epoch${EPOCH}"
	TRANSFER_TAG="seed${SEED_NUM[$i]}_${TRANSFER_DATASET}_${NET}Transfer_lr${LEARNING_RATE}_bs${BATCH_SIZE}_epoch${EPOCH}"
    LOG_DIR="./runs/${TAG}"
	RES_DIR="./result/${TAG}"
    TRANSFER_LOG_DIR="./runs/${TRANSFER_TAG}"
    TRANSFER_RES_DIR="./result/${TRANSFER_TAG}"
    CKPT="./result/${TAG}/pytorch_model.bin"
	ARGS="main.py --seed-num ${SEED_NUM[$i]} --gpu-id ${GPU_ID} --save --lr ${LEARNING_RATE} --net ${NET} --batch-size ${BATCH_SIZE} --n-epochs ${EPOCH}"
    TRANSFER_ARGS="${ARGS} --transfer --ckpt ${CKPT}"
	echo ${TAG}
	python ${ARGS} --dataset ${DATASET} --log-dir ${LOG_DIR} --res-dir ${RES_DIR} --res-tag ${TAG}
    echo ${TRANSFER_TAG}
    python ${TRANSFER_ARGS} --dataset ${TRANSFER_DATASET} --log-dir ${TRANSFER_LOG_DIR} --res-dir ${TRANSFER_RES_DIR} --res-tag ${TRANSFER_TAG}
done	
