# ~/bin/bash
LEARNING_RATE=0.1
NET="resnet50_supCon"
TRANSFER_NET="resnet50_supLinear"
EPOCH=200
GPU_ID=1
BATCH_SIZE=128
DATASET="coarse_cifar100"
TRANSFER_DATASET="cifar100"
SEED_NUM=(0)
for (( i=0; i<${#SEED_NUM[@]}; i++ ))
do
	TAG="seed${SEED_NUM[$i]}_${DATASET}_${NET}_lr${LEARNING_RATE}_bs${BATCH_SIZE}_epoch${EPOCH}"
	TRANSFER_TAG="seed${SEED_NUM[$i]}_${TRANSFER_DATASET}_${TRANSFER_NET}Transfer_lr${LEARNING_RATE}_bs${BATCH_SIZE}_epoch${EPOCH}"
    LOG_DIR="./runs/${TAG}"
	RES_DIR="./result/${TAG}"
    CKPT="./result/${TAG}/pytorch_model.bin"
	ARGS="main.py --seed-num ${SEED_NUM[$i]} --gpu-id ${GPU_ID} --save --res-dir ${RES_DIR} --res-tag ${TAG} --lr ${LEARNING_RATE} --batch-size ${BATCH_SIZE} --n-epochs ${EPOCH} --log-dir ${LOG_DIR}"
    TRANSFER_ARGS="${ARGS} --transfer --ckpt ${CKPT}"
	echo ${TAG}
	python ${ARGS} --dataset ${DATASET} --net ${NET}
    echo ${TRANSFER_TAG}
    python ${TRANSFER_ARGS} --dataset ${TRANSFER_DATASET} --net ${TRANSFER_NET}
done	
