# ~/bin/bash
LEARNING_RATE=0.0003
TRANSFER_LEARNING_RATE=0.001
BATCH_SIZE=128
NET="resnet50_supCon"
TRANSFER_NET="resnet50_supLinear"
DATASET="coarse_cifar10"
TRANSFER_DATASET="cifar10"
GPU_ID=3
EPOCH=600
TRANSFER_EPOCH=100
SEED_NUM=(0)
for (( i=0; i<${#SEED_NUM[@]}; i++ ))
do
	TAG="seed${SEED_NUM[$i]}_${DATASET}_${NET}_lr${LEARNING_RATE}_bs${BATCH_SIZE}_epoch${EPOCH}"
    TRANSFER_TAG="seed${SEED_NUM[$i]}_${TRANSFER_DATASET}_${TRANSFER_NET}Transfer_lr${TRANSFER_LEARNING_RATE}_bs${BATCH_SIZE}_epoch${EPOCH}"
	LOG_DIR="./runs/${TAG}"
	RES_DIR="./result/${TAG}"
    TRANSFER_LOG_DIR="./runs/${TRANSFER_TAG}"
    TRANSFER_RES_DIR="./result/${TRANSFER_TAG}"
    CKPT="./result/${TAG}/pytorch_model.bin"
	ARGS="main.py --gpu-id ${GPU_ID} --save --seed-num ${SEED_NUM[$i]} --batch-size ${BATCH_SIZE}"
	TRANSFER_ARGS="${ARGS} --transfer --ckpt ${CKPT}"
	echo ${TAG}
    python ${ARGS} --dataset ${DATASET} --log-dir ${LOG_DIR} --res-dir ${RES_DIR} --lr ${LEARNING_RATE} --res-tag ${TAG} --n-epochs ${EPOCH} --net ${NET}
    echo ${TRANSFER_TAG}
	python ${TRANSFER_ARGS} --dataset ${TRANSFER_DATASET} --log-dir ${TRANSFER_LOG_DIR} --res-dir ${TRANSFER_RES_DIR} --lr ${TRANSFER_LEARNING_RATE} --res-tag ${TRANSFER_TAG} --n-epochs ${TRANSFER_EPOCH} --net ${TRANSFER_NET}
done

