#!/bin/bash
RES_DIR="./result"
SEED=(1)
NET=("dense_AMA")

for seed in ${SEED[@]}
do
    for net in ${NET[@]}
    do
        case ${net} in (*"dense"*)
            echo "***** DenseNet *****"
            ARGS="--data-dir data --net ${net} --n_epochs 300 --batch-size 64 --lr 0.1 \
                  --save --res-dir ${RES_DIR} --seed-num ${seed}"
            echo "${net}_seed${seed}"
            python main_ddp.py ${ARGS}
            ;;
        (*)
            ! 
            ARGS="--data-dir data --net ${net} --n_epochs 200 --batch-size 256 --lr 0.1 \
                  --save --res-dir ${RES_DIR} --seed-num ${seed}"
            echo "${net}_seed${seed}"
            python main_ddp.py ${ARGS}
            ;;
        esac
    done
done
