# !/bin/bash
GPU_ID=3

NET="resnet32_AMA"
DATA_DIR="./data"

for SEED in 2
do
    for IF in 0.1 0.02 0.01     # Imbalanced Factor 10, 50, 100 -> 0.1, 0.02, 0.01
    do
        TAG="CIFAR100LT_${NET}_imb${IF}_seed${SEED}"
        LOG_DIR="./runs/${TAG}"
        RES_DIR="./result/${TAG}"
        echo ${TAG}
        ARGS="--data-dir ${DATA_DIR} --dataset cifar100 --gpu-id ${GPU_ID} --net ${NET} \
              --n_epochs 400 --batch-size 256 --weight-decay 5e-4 \
              --imb-factor ${IF} --seed-num ${SEED} \
              --save --res-dir ${RES_DIR} --res-tag ${TAG} --log-dir ${LOG_DIR}"
        python main.py ${ARGS}
    done
done
