import torch
import torch.nn as nn
import torch.nn.functional as F
from torch.nn import init

import math
import random
import numpy as np

BOUND = 1e-6
PI = math.pi


def set_random_seed(seed_num=1):
	random.seed(seed_num)
	np.random.seed(seed_num)
	torch.manual_seed(seed_num)
	torch.cuda.manual_seed(seed_num)
	torch.cuda.manual_seed_all(seed_num)
	torch.backends.cudnn.deterministic = True
	torch.backends.cudnn.benchmark = False

