# ~/bin/bash
LEARNING_RATE=0.05
BATCH_SIZE=128
DATASET="cifar10"
GPU_ID=1
EPOCH=300
SEED_NUM=(1)

for (( i=0; i<${#SEED_NUM[@]}; i++ ))
do
    for NET in "resnet50_supCon" "resnet50_supLinear"
    do
        TAG="seed${SEED_NUM[$i]}_${DATASET}_${NET}_lr${LEARNING_RATE}_bs${BATCH_SIZE}_epoch${EPOCH}"
        LOG_DIR="./runs/${TAG}"
        RES_DIR="./result/${TAG}"
        ARGS="main.py --gpu-id ${GPU_ID} --save --seed-num ${SEED_NUM[$i]} --res-dir ${RES_DIR} --res-tag ${TAG} --lr ${LEARNING_RATE} --dataset ${DATASET} --net ${NET} --batch-size ${BATCH_SIZE} --n-epochs ${EPOCH} --log-dir ${LOG_DIR}"
        if [ ${NET} == "resnet50_supLinear" ]
        then
            CKPT="./result/seed${SEED_NUM[$i]}_${DATASET}_resnet50_supCon_lr${LEARNING_RATE}_bs${BATCH_SIZE}_epoch${EPOCH}/pytorch_model.bin"
            ARGS="${ARGS} --ckpt ${CKPT}"
        fi
        echo ${TAG}
        python ${ARGS}
    done
done
