#!/bin/bash
RES_DIR="./result"
NET="ResNet50TinySupCon"
CLASSIFIER="ResNet50TinySupLinear"

for SEED in 1
do
    ARGS="--data-dir data --net ${NET} --n_epochs 200 --batch-size 256 --lr 0.1 \
          --save --res-dir ${RES_DIR} --seed-num ${SEED}"
    echo "${NET}_seed${SEED}"
    python supcon_ddp.py ${ARGS}

    CKPT="${RES_DIR}/${NET}_e200_lr0.1_bsz32_seed${SEED}.pth"
    LIN_ARGS="--data-dir data --net ${CLASSIFIER} --n_epochs 200 --batch-size 256 --lr 0.1 --ckpt ${CKPT} --save --res-dir ${RES_DIR} --seed-num ${SEED}"
    echo "${CLASSIFIER}_seed${SEED}"
    python supcon_ddp.py ${LIN_ARGS}
done
