# !/bin/bash
GPU_ID=2
DATA_DIR="./data"

for SEED in 2
do
    for IF in 0.1 0.02 0.01     # Imbalanced Factor 10, 50, 100 -> 0.1, 0.02, 0.01
    do
        for NET in "resnet32_supCon" "resnet32_supLinear"
        do
            TAG="CIFAR10LT_${NET}_imb${IF}_seed${SEED}"
            LOG_DIR="./runs/${TAG}"
            RES_DIR="./result/${TAG}"
            echo ${TAG}
            ARGS="--data-dir ${DATA_DIR} --dataset cifar10 --gpu-id ${GPU_ID} --net ${NET} \
                  --n_epochs 400 --batch-size 256 --weight-decay 5e-4 \
                  --imb-factor ${IF} --seed-num ${SEED} \
                  --save --res-dir ${RES_DIR} --res-tag ${TAG} --log-dir ${LOG_DIR}"
            if [ $NET == "resnet32_supLinear" ]
            then
                CKPT="./result/CIFAR100LT_resnet32_supCon_imb${IF}_seed${SEED}/pytorch_model.bin"
                ARGS="$ARGS --ckpt $CKPT"
            fi
            python main.py ${ARGS}
        done
    done
done
