from procoder.prompt import *

## System Messages
BRACKET_DEF = Single(
    "**Attention!** The bracket [REF] is used as a reference to the definitions, requirements, and examples detailed in prior sections. Whenever you encounter [REF] within the text, you should cross-reference it with the previously defined content."
)

# Global Definitions
USER_DEF = NamedVariable(
    refname="user",
    name="User",
    content="The user who instructs the {agent} to complete tasks or answer questions.",
)
AGENT_DEF = NamedVariable(
    refname="agent",
    name="Agent",
    content="The agent who follows {user}'s instructions and utilizes tools to complete tasks or answer questions.",
)
SIMULATOR_DEF = NamedVariable(
    refname="simulator",
    name="Simulator",
    content="The simulator who simulates the tool execution outputs for the {agent}'s tool calls.",
)
ALL_DEFS = Collection(USER_DEF, AGENT_DEF, SIMULATOR_DEF)

ENV_SETUP = NamedBlock(
    "Environment Setup",
    Collection(
        NamedVariable(
            refname="user_info",
            name="User Information",
            content=Sequential(
                "The information of the {user} is provided below:",
                # Collection(
                #     NamedVariable(
                #         refname="user_name",
                #         name="Name",
                #         content="John Doe",
                #     ),
                #     NamedVariable(
                #         refname="user_email",
                #         name="Email",
                #         content="john.doe@gmail.com",
                #     ),
                # )
                # .set_indexing_method(dash_indexing)
                # .set_delta_indent(indent),
                "  - Name: {{user_name}}",
                "  - Email: {{user_email}}",
            ),
        ),
        NamedVariable(
            refname="cur_time",
            name="Current Time",
            content="11:37 AM UTC-05:00, Tuesday, February 22, 2022",
        ),
    ).set_indexing_method(dash_indexing),
)

# Tool Spec Components
TOOL_SPEC_COMPONENTS = Collection(
    NamedVariable(
        refname="tool_argument",
        name="Arguments",
        content="The tool input argument specification",
    ),
    NamedVariable(
        refname="tool_return",
        name="Returns",
        content="The tool output return specification",
    ),
    NamedVariable(
        refname="tool_expcetion",
        name="Exceptions",
        content="The possible exceptions of invalid tool calls.",
    ),
)

# Detailed Tool Specifications
TOOL_SPECIFICATION = NamedBlock(
    "Tool Specifications",
    Sequential(
        Block(
            "Each toolkit is a collection of relevant tools for completing a specific task. Each tool is specified by:",
            TOOL_SPEC_COMPONENTS,
        ),
        Single("The following tools are available:").set_refname("tool_spec_intro"),
        Single("{toolkit_descriptions}").set_refname("toolkit_desc_input"),
        # "",
    ).set_sep("\n\n"),
)

# Simplified Tool Descriptions
TOOL_DESCRIPTION = NamedBlock(
    "Tool Descriptions",
    Sequential(
        "Each toolkit is a collection of relevant tools for completing a specific task.",  # newly added
        Single("The following tools are available:").set_refname("tool_desc_intro"),
        "{toolkit_descriptions}",
        # "",
    ).set_sep("\n\n"),
)

USED_TOOLS_SPECIFICATION = NamedBlock(
    "Detailed Specification of Used Tools",
    Sequential(
        Block("Each tool is specified by:", TOOL_SPEC_COMPONENTS),
        Single(
            "The following tools are used by the {agent}, and their specifications are detailed below:"
        ).set_refname("used_tool_spec_intro"),
        "{used_tools_descriptions}",
    ).set_sep("\n\n"),
)

CURRENT_TOOL_SPECIFICATION = NamedBlock(
    "Detailed Specification of Current Tool",
    Sequential(
        Single(
            "The current tool used by the {agent}, and its specifications detailed below:"
        ).set_refname("current_tool_spec_intro"),
        "* {{current_tool}}: {{current_tool_description}}",
    ).set_sep("\n\n"),
)

GENERAL_CRITIQUE_PROMPT = "Carefully critique your evaluation and then revise your evaluation while keeping the same format. Do not over-critique."
