# Diffusion Probabilistic Models for Structured Node classifications

## Repository Overview
We provide the PyTorch implementation for DPM-SNC framework here. The repository is organised as follows:

```python
|-- {transductive-node-classification, transductive-node-classification-hetero, inductive-node-classification, graph-algorithm-reasoning} # DPM-GSP for supervised node classification, semi-supervised node classification, and reasoning tasks
    |-- config/ # configurations
    |-- parsers/ # the argument parser
    |-- models/ # model definition
    |-- method_series/ # training method
    |-- data/ # dataset
    |-- logs_train/ # training logs
    |-- utils/ # data process and others
    |-- main.py # the training code
```

## Setting up the environment
You can set up the environment by following commands. 

```sh
conda create -n DPM-SNC python=3.10
conda install pytorch==1.12.1 torchvision==0.13.1 torchaudio==0.12.1 cudatoolkit=11.3 -c pytorch
pip install tqdm
pip install pyyaml
pip install easydict
pip install torch-sparse
pip install torch-scatter==2.0.9
```
You also need to install torch-geometric package. Each experiment requires a different version.

### DPM-SNC for fully-supervised and reasoning  
```sh
pip install torch-geometric==1.7.1
```

### DPM-SNC-semi-supervised  
```sh
pip install torch-geometric==2.1.0
```

### DPM-SNC-transductive-hetero
```sh
pip install torch-geometric==2.3.1
```
Here, deep graph library (dgl) 0.9.1 is also required.

## Running
At each directory, you can use the following command to obtain the results of our paper.


### DPM-SNC-transductive-node-classification
In the case of transductive node classification, we provide codes for baselines.

```sh
CUDA_VISIBLE_DEVICES=$GPU_DEVICE python main.py \
--config config_name --method {dpm,g3nn,gmnn,lpa,clgnn,base}
```

### Others
```sh
CUDA_VISIBLE_DEVICES=$GPU_DEVICE python main.py \
--config config_name
```
