#!/bin/bash

ROT="--n_layers 2 --n_hiddens 100 --data_path data/ --log_every 100 --samples_per_task 1000 --dataset mnist_rotations    --cuda --log_dir logs/"
PERM= "--n_layers 2 --n_hiddens 100 --data_path data/ --log_every 100 --samples_per_task 1000 --dataset mnist_permutations --cuda --log_dir logs/"
MANY= "--n_layers 2 --n_hiddens 100 --data_path data/ --log_every 100 --samples_per_task 200 --dataset mnist_manypermutations --cuda --log_dir logs/"
CIFAR= '--data_path data/ --log_every 100 --dataset cifar100 --cuda --log_dir logs/'
IMGNET= '--data_path data/tiny-imagenet-200/ --log_every 100 --dataset tinyimagenet --cuda --log_dir logs/'
CIFAR10= '--data_path data/ --cuda --dataset cifar10 --cuda --log_dir logs/ '
SEED=0
exe() { echo "\$ $@" ; "$@" ; }

########## MNIST DATASETS ##########
##### sparse La-MAML #####

exe echo Training La-MAML rotation
# ROTATION
#lamaml
python3 main.py $ROT --model lamaml --memories 200 --batch_size 10 --replay_batch_size 10 --n_epochs 1 --glances 5 --opt_lr 0.3 \
	                    --alpha_init 0.15 --learn_lr --use_old_task_memory --seed $SEED

exe echo Training La-MAML permutation
#PERMUTATION
#lamaml
python3 main.py $PERM --model lamaml --memories 200 --batch_size 10 --replay_batch_size 10 --n_epochs 1 --glances 5 --opt_lr 0.3 \
	                    --alpha_init 0.15 --learn_lr --use_old_task_memory --seed $SEED

exe echo Training La-MAML many
#MANY
#lamaml
python3 main.py $MANY --model lamaml --memories 500 --batch_size 10 --replay_batch_size 10 --n_epochs 1 --glances 10 --opt_lr 0.1 \
	                    --alpha_init 0.1 --learn_lr --use_old_task_memory --seed $SEED

exe echo training cifar10 baselines
# Replay buffer of size 200
python3 train.py $CIFAR10 --model meralg1 --expt_name meralg1 --memories 200  \
                  --replay_batch_size 10 --lr 0.08 --beta 0.05 --gamma 0.05 --batches_per_example 10 --loader class_incremental_loader  --increment 2 \
									--arch 'pc_cnn' --log_every 3125 --grad_clip_norm 10.0 --class_order random --calc_test_accuracy --validation 0.1 --seed $SEED


python3 train.py $CIFAR10 --dataset cifar10 --model gem --expt_name gem --n_memories 40 --batch_size 20 \
                 --n_epochs 1 --lr 0.005 --glances 2 --memory_strength 0.5 --loader class_incremental_loader --increment 2 \
								 --arch pc_cnn --log_every 3125 --class_order random --samples_per_task 500 --calc_test_accuracy --validation 0.1\
								  --grad_clip_norm 1.0 --seed $SEED

python3 train.py $CIFAR10 --cuda --dataset cifar10 --model lamaml --expt_name lamaml --memories 200 --batch_size 10 --replay_batch_size 10 \
                  --n_epochs 1 --opt_lr 0.1 --alpha_init 0.005 --opt_wt 0.5 --glances 2 --loader class_incremental_loader --increment 2 --arch pc_cnn \
									--log_every 3125 --class_order random --calc_test_accuracy --validation 0.1 --grad_clip_norm 1.0 --second_order --cifar_batches 5 --learn_lr --seed $SEED

python3 main.py $CIFAR10 --model eralg4 --expt_name eralg4 --memories 200 --batch_size 10 --replay_batch_size 20 --n_epochs 1 \
                     --lr 0.01 --glances 1 --loader class_incremental_loader  --increment 2 \
                    --arch "pc_cnn" --log_every 3125 --class_order random \
                    --seed $SEED --calc_test_accuracy --validation 0.1
# Replay buffer of size 1000
python3 train.py $CIFAR10 --model meralg1 --expt_name meralg1 --memories 1000  \
                  --replay_batch_size 10 --lr 0.08 --beta 0.05 --gamma 0.05 --batches_per_example 10 --loader class_incremental_loader  --increment 2 \
									--arch 'pc_cnn' --log_every 3125 --grad_clip_norm 10.0 --class_order random --calc_test_accuracy --validation 0.1 --seed $SEED


python3 train.py $CIFAR10 --dataset cifar10 --model gem --expt_name gem --n_memories 200 --batch_size 5 \
                 --n_epochs 1 --lr 0.005 --glances 2 --memory_strength 0.5 --loader class_incremental_loader --increment 2 \
								 --arch pc_cnn --log_every 3125 --class_order random --samples_per_task 500 --calc_test_accuracy --validation 0.1\
								  --grad_clip_norm 1.0 --seed $SEED

python3 train.py $CIFAR10 --cuda --dataset cifar10 --model lamaml --expt_name lamaml --memories 1000 --batch_size 10 --replay_batch_size 10 \
                  --n_epochs 1 --opt_lr 0.01 --alpha_init 0.01 --opt_wt 0.5 --glances 2 --loader class_incremental_loader --increment 2 --arch pc_cnn \
									--log_every 3125 --class_order random --calc_test_accuracy --validation 0.1 --grad_clip_norm 1.0 --second_order --cifar_batches 5 --learn_lr --seed $SEED

python3 main.py $CIFAR10 --model eralg4 --expt_name eralg4 --memories 1000 --batch_size 10 --replay_batch_size 10 --n_epochs 1 \
                     --lr 0.01 --glances 5 --loader class_incremental_loader  --increment 2 \
                    --arch "pc_cnn" --log_every 3125 --class_order random \
                    --seed $SEED --calc_test_accuracy --validation 0.1
