using JLD2, Printf, StatsPlots, ArgParse;

include("runit.jl");
include("helpers_experiments.jl");
include("helpers.jl");

function parse_commandline()
    s = ArgParseSettings();

    @add_arg_table! s begin
        "--exp_dir"
            help = "Directory for loading the experiment's data, while saving the plots in the corresponding folder."
            arg_type = String
            default = "experiments/"
        "--format"
            help = "Format to save the figures."
            arg_type = String
            default = "pdf"
    end

    parse_args(s);
end

parsed_args = parse_commandline();
exp_dir = parsed_args["exp_dir"];
format = parsed_args["format"];

experiments = filter(x -> isdir("$(exp_dir)$x"), readdir(exp_dir));
for experiment in experiments
    # Check for existing plots in the corresponding format
    existing_plots = length(filter(x -> occursin(".$format", x), readdir("$(exp_dir)$(experiment)/"))) != 0;

    if ! existing_plots
        println("Creating plots in .$format based on $(exp_dir)$(experiment) ...");

        name_experiment = split(experiment, ":")[2];
        @load "$(exp_dir)$(experiment)/$(name_experiment).dat" dists μs Tstar wstar pep iss data δs Nruns seed;

        delta = split(string(δs[1]), ".")[2];

        # Constant vs Adaptive
        iss_to_keep = ["cst-UCBI-TC-T-G-GK16", "BC-UCBI-TC-T-G-GK16",
                       "cst-EB-TCI-G-GK16", "BC-EB-TCI-G-GK16",
                       "cst-TS-TC-G-GK16", "BC-TS-TC-G-GK16",
                       "cst-TS-RS-G-GK16", "BC-TS-RS-G-GK16"];
        name_iss = ["TTUCB", "A-TTUCB", "EB-TCI", "A-EB-TCI", "T3C", "A-T3C", "TTTS", "A-TTTS"];
        file_plot_samp = "$(exp_dir)$(experiment)/plot_samp_cva_$(name_experiment)_delta$(delta).$format";
        plot_samp(pep, μs, Tstar, wstar, δs[1], iss, getindex.(data, 1), Nruns, file_plot_samp, iss_to_keep, name_iss);

    else
        println("Plots in .$format based on $(exp_dir)$(experiment) already exist.");
    end
    println("");
end
